/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnnounceCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        AnnounceType announceType = AnnounceType.ALL;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("TO_OPS", arg)) {
                announceType = AnnounceType.TO_OPS;
                continue;
            }
            text = aH.getStringFrom(arg);
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String text = (String)scriptEntry.getObject("text");
        AnnounceType type = (AnnounceType)((Object)scriptEntry.getObject("type"));
        dB.report(this.getName(), aH.debugObj("Message", text) + aH.debugObj("Type", type.name()));
        if (type == AnnounceType.ALL) {
            this.denizen.getServer().broadcastMessage(text);
        } else if (type == AnnounceType.TO_OPS) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(text);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AnnounceType {
        ALL,
        TO_OPS;

    }
}

