/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RuntaskCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Script script = null;
        HashMap<String, String> context = null;
        Duration delay = new Duration(0);
        Duration speed = new Duration((double)Settings.InteractDelayInTicks() / 20.0);
        ScriptQueue queue = ScriptQueue._getQueue(scriptEntry.getResidingQueue());
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                delay = aH.getDurationFrom(arg);
                delay.setPrefix("Delay");
                continue;
            }
            if (aH.matchesQueue(arg)) {
                queue = aH.getQueueFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SPEED", arg, aH.ArgumentType.Duration)) {
                speed = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesArg("QUEUE", arg)) continue;
            if (aH.matchesArg("INSTANT, INSTANTLY", arg)) {
                speed = new Duration(0);
                continue;
            }
            if (aH.matchesValueArg("CONTEXT", arg, aH.ArgumentType.Custom)) {
                context = new HashMap<String, String>();
                List<String> contexts = aH.getListFrom(arg);
                int x = 1;
                for (String ctxt : contexts) {
                    context.put(String.valueOf(x), ctxt.trim());
                    ++x;
                }
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.Word)) continue;
            if (ScriptRegistry.containsScript(aH.getStringFrom(arg))) {
                script = aH.getScriptFrom(arg);
                if (script.getType().equalsIgnoreCase("TASK")) continue;
                script = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (script == null) {
            throw new InvalidArgumentsException("Must define a script to be run!");
        }
        scriptEntry.addObject("speed", speed.setPrefix("Speed")).addObject("queue", queue).addObject("delay", delay.setPrefix("Delay")).addObject("script", script).addObject("context", context);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        HashMap context = (HashMap)scriptEntry.getObject("context");
        Script script = (Script)scriptEntry.getObject("script");
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration speed = (Duration)scriptEntry.getObject("speed");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.echoApproval("Executing '" + this.getName() + "': " + script.debug() + delay.debug() + speed.debug() + "Queue='" + queue.toString());
        if (delay.getSeconds() <= 0.0) {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScript(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
        } else {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScriptWithDelay(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context, delay);
        }
    }
}

