/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ContextTags
implements Listener {
    public ContextTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void getEntry(ReplaceableTagEvent event) {
        if (!event.matches("ENTRY") || event.getScriptEntry() == null) {
            return;
        }
        String type = event.getType();
        String subType = "";
        if (event.hasSubType()) {
            subType = event.getSubType();
        }
        ScriptEntry entry = event.getScriptEntry();
        if (type.equalsIgnoreCase("PLAYER")) {
            event.setReplaced(entry.getPlayer().getName());
        } else if (type.equalsIgnoreCase("SCRIPT")) {
            if (subType.equalsIgnoreCase("NAME")) {
                event.setReplaced(entry.getScript().getName());
            }
        } else if (type.equalsIgnoreCase("OBJECT")) {
            if (entry.hasObject(subType)) {
                event.setReplaced(entry.getObject(subType).toString());
            }
        } else if (type.equalsIgnoreCase("SCRIPT") && subType.equalsIgnoreCase("QUEUE")) {
            event.setReplaced(entry.getResidingQueue());
        }
    }

    @EventHandler
    public void getContext(ReplaceableTagEvent event) {
        Map<String, Integer> id;
        HashMap context;
        if (!event.matches("CONTEXT") || event.getScriptEntry() == null) {
            return;
        }
        if (!ScriptRegistry.containsScript(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class)) {
            return;
        }
        TaskScriptContainer script = ScriptRegistry.getScriptContainerAs(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class);
        String type = event.getType();
        ScriptEntry entry = event.getScriptEntry();
        if (entry.hasObject("CONTEXT") && (context = (HashMap)entry.getObject("CONTEXT")).containsKey(String.valueOf((id = script.getContextMap()).get(type.toUpperCase())))) {
            event.setReplaced((String)context.get(type.toUpperCase()));
        }
    }
}

