/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.shade.json.JSONArray;
import org.shade.json.JSONException;
import org.shade.json.JSONObject;

public class ScriptRepo {
    private static String API = "http://scripts.citizensnpcs.com/api.php";

    public static void info(CommandSender cs, String id) throws JSONException {
        JSONObject data = ScriptRepo.queryAPI("view&dscript&pubID=" + id);
        if (data.getBoolean("success")) {
            JSONObject entry = data.getJSONObject("entryData");
            Messaging.send((CommandSender)cs, (Object[])new Object[]{entry.getString("pubID") + " - " + entry.getString("name") + " by " + entry.getString("author")});
            Messaging.send((CommandSender)cs, (Object[])new Object[]{entry.getString("description").replaceAll("\\r\\n", "\n")});
            if (entry.getInt("dscript") == 1) {
                Messaging.send((CommandSender)cs, (Object[])new Object[]{"You can load this script with /citizens denizen repo load " + entry.getString("pubID")});
            } else {
                Messaging.send((CommandSender)cs, (Object[])new Object[]{"This script does not support being loaded ingame. Check http://scripts.citizensnpcs.com/view/" + entry.getString("pubID") + " for info."});
            }
        } else {
            Messaging.send((CommandSender)cs, (Object[])new Object[]{"Could not find that script!"});
        }
    }

    public static void search(CommandSender cs, String query) throws JSONException {
        ScriptRepo.search(cs, query, 1);
    }

    public static void search(CommandSender cs, String query, int page) throws JSONException {
        JSONObject data = ScriptRepo.queryAPI("search&dscript&count=8&page=" + page + "&query=" + query);
        if (data.getBoolean("success")) {
            JSONArray resultlist = data.getJSONArray("results");
            ArrayList<JSONObject> results = new ArrayList<JSONObject>();
            for (int i = 0; i < resultlist.length(); ++i) {
                if (resultlist.isNull(i)) continue;
                results.add(resultlist.getJSONObject(i));
            }
            if (!results.isEmpty()) {
                Messaging.send((CommandSender)cs, (Object[])new Object[]{results.size() + " results found:"});
                for (JSONObject j : results) {
                    Messaging.send((CommandSender)cs, (Object[])new Object[]{j.getString("pubID") + " - " + j.getString("name") + " by " + j.getString("author")});
                }
            } else {
                Messaging.send((CommandSender)cs, (Object[])new Object[]{"No results found. Try a different search query!"});
            }
        } else {
            Messaging.send((CommandSender)cs, (Object[])new Object[]{"Uh oh, something went wrong..."});
        }
    }

    public static void load(CommandSender cs, String id) throws JSONException {
        JSONObject data = ScriptRepo.queryAPI("download&dscript&pubID=" + id);
        if (data.getBoolean("success")) {
            String yaml = data.getString("code").replaceAll("\\r\\n", "\n");
            Denizen plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
            File file = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "scripts" + File.separator + data.getString("name") + ".dscript");
            if (!file.exists()) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(file.getAbsoluteFile()));
                    bw.write(yaml);
                    bw.close();
                    Messaging.send((CommandSender)cs, (Object[])new Object[]{"Downloaded script from repo. Reloading scripts..."});
                    ScriptHelper.reloadScripts();
                    Messaging.send((CommandSender)cs, (Object[])new Object[]{"Reloaded scripts!"});
                }
                catch (IOException e) {
                    Messaging.send((CommandSender)cs, (Object[])new Object[]{"Looks like something went wrong while writing the file. Check console for details."});
                    e.printStackTrace();
                }
            } else {
                Messaging.send((CommandSender)cs, (Object[])new Object[]{"A script by that name appears to already exist!"});
            }
        } else if (data.has("cause") && data.getString("cause").equalsIgnoreCase("dscript")) {
            Messaging.send((CommandSender)cs, (Object[])new Object[]{"This script does not support dscript functionality!"});
        } else {
            Messaging.send((CommandSender)cs, (Object[])new Object[]{"Could not download that script!"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject queryAPI(String queryArgs) {
        JSONObject j = null;
        try {
            InputStreamReader is = new InputStreamReader(new URL(API + "?" + queryArgs).openStream(), Charset.forName("UTF-8"));
            try {
                j = new JSONObject(ScriptRepo.readAll(new BufferedReader(is)));
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return j;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }
}

