/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ChairCommand
extends AbstractCommand
implements Listener {
    public ConcurrentHashMap<Integer, Block> chairRegistry = new ConcurrentHashMap();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Block chairBlock = null;
        ChairAction chairAction = ChairAction.SIT;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                chairBlock = aH.getLocationFrom(arg).getBlock();
                continue;
            }
            if (aH.matchesArg("SIT, STAND", arg)) {
                chairAction = ChairAction.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (chairBlock == null && chairAction != ChairAction.STAND) {
            throw new InvalidArgumentsException("Must specify a location to sit!");
        }
        scriptEntry.addObject("chairBlock", chairBlock).addObject("chairAction", (Object)chairAction);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Block chairBlock = (Block)scriptEntry.getObject("chairBlock");
        ChairAction chairAction = (ChairAction)((Object)scriptEntry.getObject("chairAction"));
        dNPC npc = scriptEntry.getNPC();
        switch (chairAction) {
            case SIT: {
                if (this.isChair(chairBlock).booleanValue()) {
                    dB.echoError("...location is already being sat on!");
                    return;
                }
                if (this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already sitting!");
                    return;
                }
                npc.getEntity().teleport(chairBlock.getLocation().add(0.5, 0.0, 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
                this.makeSitAllPlayers(npc, chairBlock);
                npc.action("sit", scriptEntry.getPlayer());
                break;
            }
            case STAND: {
                if (!this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already standing!");
                    return;
                }
                this.makeStand(npc);
                npc.action("stand", scriptEntry.getPlayer());
            }
        }
    }

    public void makeSitAllPlayers(dNPC npc, Block block) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
        this.chairRegistry.put(npc.getId(), block);
    }

    public void makeSitSpecificPlayer(dNPC npc, Player player) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            if (npc.getEntity().getWorld().equals(player.getWorld())) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (Exception e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
    }

    public void makeStand(dNPC npc) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)0);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
        this.chairRegistry.remove(npc);
    }

    public Boolean isSitting(dNPC npc) {
        if (this.chairRegistry.containsKey(npc.getId())) {
            return true;
        }
        return false;
    }

    public Boolean isChair(Block block) {
        if (this.chairRegistry.containsValue(block)) {
            return true;
        }
        return false;
    }

    @EventHandler
    public void onNavigationBeginEvent(NavigationBeginEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (this.isSitting(npc).booleanValue()) {
            this.makeStand(npc);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isChair(event.getBlock()).booleanValue()) {
            event.setCancelled(true);
            dB.echoDebug("..." + event.getPlayer().getName() + " tried to break an NPCs chair!");
        }
    }

    @EventHandler
    public void onPlayerLoginEvent(PlayerJoinEvent event) {
        HashSet<dNPC> npcs = new HashSet<dNPC>();
        for (Integer intgr : this.chairRegistry.keySet()) {
            npcs.add(DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getById(intgr.intValue())));
        }
        for (dNPC npc : npcs) {
            this.makeSitSpecificPlayer(npc, event.getPlayer());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChairAction {
        SIT,
        STAND;

    }
}

