/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScriptContainer
extends ScriptContainer {
    public TaskScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public Duration getSpeed() {
        Duration speed = Duration.valueOf(this.getString("SPEED", null));
        if (speed == null) {
            speed = new Duration((double)(Settings.InteractDelayInTicks() / 20));
        }
        return speed;
    }

    public TaskScriptContainer setInstant() {
        this.set("SPEED", "INSTANT");
        return this;
    }

    public TaskScriptContainer setSpeed(Duration speed) {
        this.set("SPEED", speed.getSeconds());
        return this;
    }

    public boolean isInstant() {
        return this.getSpeed() != null && (this.getSpeed().getSeconds() <= 0.0 || this.getString("SPEED").equalsIgnoreCase("INSTANT"));
    }

    public ScriptQueue runTaskScript(Player player, dNPC npc, Map<String, String> context) {
        return this.runTaskScript(ScriptQueue._getNextId(), player, npc, context);
    }

    public ScriptQueue runTaskScript(String queueId, Player player, dNPC npc, Map<String, String> context) {
        ScriptQueue queue = ScriptQueue._getQueue(queueId);
        List<ScriptEntry> listOfEntries = this.getBaseEntries(player, npc);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        if (this.isInstant()) {
            queue.setSpeed(0);
        } else if (this.getSpeed() != null) {
            queue.setSpeed(this.getSpeed().getTicksAsInt());
        }
        queue.start();
        return queue;
    }

    public Map<String, Integer> getContextMap() {
        if (this.contains("CONTEXT")) {
            HashMap<String, Integer> context = new HashMap<String, Integer>();
            int x = 1;
            for (String name : this.getString("CONTEXT").split("\\|")) {
                context.put(name.toUpperCase(), x);
                ++x;
            }
            return context;
        }
        return Collections.emptyMap();
    }

    public ScriptQueue runTaskScriptWithDelay(String queueId, Player player, dNPC npc, Map<String, String> context, Duration delay) {
        ScriptQueue queue = ScriptQueue._getQueue(queueId);
        List<ScriptEntry> listOfEntries = this.getBaseEntries(player, npc);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        if (this.isInstant()) {
            queue.setSpeed(0);
        } else if (this.getSpeed() != null) {
            queue.setSpeed(this.getSpeed().getTicksAsInt());
        }
        queue.delayUntil(System.currentTimeMillis() + (long)(delay.getSeconds() * 1000.0));
        queue.start();
        return queue;
    }
}

