/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class ModifyBlockCommand
extends AbstractCommand {
    private World theWorld;
    private Player thePlayer;
    private Material material;
    private Location location;
    private int radius;
    private int height;
    private int depth;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.thePlayer = scriptEntry.getPlayer();
        this.material = null;
        this.location = null;
        this.radius = 0;
        this.height = 0;
        this.depth = 0;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                this.location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to: " + this.location);
                continue;
            }
            if (aH.matchesValueArg("MATERIAL, M", arg, aH.ArgumentType.Custom)) {
                this.material = aH.matchesValueArg("MATERIAL", arg, aH.ArgumentType.Integer) ? Material.getMaterial((int)aH.getIntegerFrom(arg)) : Material.getMaterial((String)aH.getStringFrom(arg));
                if (this.material != null) {
                    dB.echoDebug("...material set to " + this.material);
                    continue;
                }
                dB.echoDebug("...material not valid.");
                continue;
            }
            if (aH.matchesValueArg("RADIUS, R", arg, aH.ArgumentType.Integer)) {
                this.radius = aH.getIntegerFrom(arg);
                dB.echoDebug("...radius set to " + this.radius);
                continue;
            }
            if (aH.matchesValueArg("HEIGHT, H", arg, aH.ArgumentType.Integer)) {
                this.height = aH.getIntegerFrom(arg);
                dB.echoDebug("...height set to " + this.height);
                continue;
            }
            if (aH.matchesValueArg("DEPTH, D", arg, aH.ArgumentType.Integer)) {
                this.depth = aH.getIntegerFrom(arg);
                dB.echoDebug("...depth set to " + this.depth);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int y;
        Block currentBlock;
        int z;
        int x;
        if (this.location == null || this.material == null) {
            dB.echoDebug("...can not exectue");
            return;
        }
        this.theWorld = this.thePlayer.getWorld();
        Block startBlock = this.location.getBlock();
        startBlock.setType(this.material);
        if (this.radius != 0) {
            for (x = 0; x < 2 * this.radius + 1; ++x) {
                for (z = 0; z < 2 * this.radius + 1; ++z) {
                    currentBlock = this.theWorld.getBlockAt(startBlock.getX() + x - this.radius, startBlock.getY(), startBlock.getZ() + z - this.radius);
                    if (currentBlock.getType() == this.material) continue;
                    currentBlock.setType(this.material);
                }
            }
        }
        if (this.height != 0) {
            for (x = 0; x < 2 * this.radius + 1; ++x) {
                for (z = 0; z < 2 * this.radius + 1; ++z) {
                    for (y = 1; y < this.height + 1; ++y) {
                        currentBlock = this.theWorld.getBlockAt(startBlock.getX() + x - this.radius, startBlock.getY() + y, startBlock.getZ() + z - this.radius);
                        if (currentBlock.getType() == this.material) continue;
                        currentBlock.setType(this.material);
                    }
                }
            }
        }
        if (this.depth != 0) {
            for (x = 0; x < 2 * this.radius + 1; ++x) {
                for (z = 0; z < 2 * this.radius + 1; ++z) {
                    for (y = 1; y < this.depth + 1; ++y) {
                        currentBlock = this.theWorld.getBlockAt(startBlock.getX() + x - this.radius, startBlock.getY() - y, startBlock.getZ() + z - this.radius);
                        if (currentBlock.getType() == this.material) continue;
                        currentBlock.setType(this.material);
                    }
                }
            }
        }
    }
}

