/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.ItemListenerType;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListenerInstance
extends AbstractListener
implements Listener {
    ItemListenerType.ItemType type = null;
    List<String> items = new ArrayList<String>();
    int quantity = 0;
    int currentItems = 0;
    Server server = Bukkit.getServer();
    String region = null;
    List<Integer> itemsCrafted = new ArrayList<Integer>();
    List<Integer> itemsSmelted = new ArrayList<Integer>();
    List<EntityType> itemsFished = new ArrayList<EntityType>();

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (aH.matchesValueArg("TYPE", arg, aH.ArgumentType.Custom)) {
                try {
                    this.type = ItemListenerType.ItemType.valueOf(aH.getStringFrom(arg).toUpperCase());
                    dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, this.type.name());
                }
                catch (Exception e) {
                    dB.echoError("Invalid ItemType!");
                }
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                this.quantity = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(this.quantity));
                continue;
            }
            if (aH.matchesValueArg("ITEMS, ITEM", arg, aH.ArgumentType.Custom)) {
                for (String thisItem : aH.getListFrom(arg)) {
                    if (this.server.getRecipesFor(new ItemStack(Material.matchMaterial((String)thisItem))) != null) {
                        this.items.add(thisItem);
                        continue;
                    }
                    dB.echoError("..." + thisItem + " is not a craftable item");
                }
                dB.echoDebug("...set ITEMS.: " + Arrays.toString(this.items.toArray()));
                continue;
            }
            if (!aH.matchesValueArg("REGION", arg, aH.ArgumentType.String)) continue;
            this.region = aH.getStringFrom(arg);
            dB.echoDebug("...region set: " + this.region);
        }
        if (this.items.isEmpty()) {
            dB.echoError("Missing ITEMS argument!");
            this.cancel();
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: CRAFT, SMELT, FISH");
            this.cancel();
        }
    }

    @EventHandler
    public void listenCraft(CraftItemEvent event) {
        if (this.type == ItemListenerType.ItemType.CRAFT && event.getWhoClicked() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.items.contains(event.getCurrentItem().getType().toString()) || this.items.contains(String.valueOf(event.getCurrentItem().getTypeId()))) {
                if (this.itemsCrafted.contains(event.getCurrentItem().getTypeId())) {
                    return;
                }
                this.itemsCrafted.add(event.getCurrentItem().getTypeId());
                ++this.currentItems;
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " crafted a " + event.getCurrentItem().getType().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenSmelt(FurnaceSmeltEvent event) {
        if (this.type == ItemListenerType.ItemType.SMELT) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            InventoryClickEvent e = (InventoryClickEvent)this.player;
            if (event.getBlock() == e.getCurrentItem() && (this.items.contains(event.getBlock().getType().toString()) || this.items.contains(String.valueOf(event.getBlock().getTypeId())))) {
                if (this.itemsSmelted.contains(event.getBlock().getTypeId())) {
                    return;
                }
                this.itemsSmelted.add(event.getBlock().getTypeId());
                ++this.currentItems;
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " smelted a " + event.getBlock().getType().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenFish(PlayerFishEvent event) {
        if (this.type == ItemListenerType.ItemType.FISH && event.getPlayer() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.items.contains(event.getCaught().getType().toString())) {
                if (this.itemsFished.contains(event.getCaught().getType())) {
                    return;
                }
                this.itemsFished.add(event.getCaught().getType());
                ++this.currentItems;
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " fished a " + event.getCaught().getType().toString() + ".");
                this.check();
            }
        }
    }

    @Override
    public void onSave() {
        try {
            this.store("Type", this.type.name());
            this.store("Items", this.items);
            this.store("Quantity Needed", this.quantity);
            this.store("Quantity Done", this.currentItems);
            this.store("Region", this.region);
        }
        catch (Exception e) {
            dB.echoError("Unable to save ITEM listener for '%s'!", this.player.getName());
        }
    }

    @Override
    public void onLoad() {
        try {
            this.type = ItemListenerType.ItemType.valueOf((String)this.get("Type"));
            this.items = (List)this.get("Items");
            this.quantity = (Integer)this.get("Quantity Needed");
            this.currentItems = (Integer)this.get("Quantity Done");
            this.region = (String)this.get("Region");
        }
        catch (Exception e) {
            dB.echoError("Unable to load ITEM listener for '%s'!", this.player.getName());
            this.cancel();
        }
    }

    @Override
    public void onFinish() {
    }

    public void check() {
        if (this.currentItems >= this.quantity) {
            CraftItemEvent.getHandlerList().unregister((Listener)this);
            FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            PlayerFishEvent.getHandlerList().unregister((Listener)this);
            this.finish();
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String report() {
        return this.player.getName() + " current has quest listener '" + this.listenerId + "' active and must " + this.type.name() + " " + Arrays.toString(this.items.toArray()) + " '(s). Current progress '" + this.currentItems + "/" + this.quantity + "'.";
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        CraftItemEvent.getHandlerList().unregister((Listener)this);
        FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
    }
}

