/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityHuman;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class SittingTrait
extends Trait
implements Listener {
    @Persist(value="sitting")
    private boolean sitting = false;
    @Persist(value="chair location")
    private Location chairLocation = null;
    EntityHuman eh = null;

    public void run() {
        if (this.eh == null || this.chairLocation == null) {
            return;
        }
        if (!Utilities.checkLocation(this.npc.getBukkitEntity(), this.chairLocation, 1)) {
            this.stand();
        }
    }

    public void onSpawn() {
        this.eh = ((CraftPlayer)this.npc.getBukkitEntity()).getHandle();
    }

    public void sit() {
        if (this.sitting) {
            dB.log("...npc is sitting");
            return;
        }
        this.eh.mount((Entity)this.eh);
        this.sitting = true;
        this.chairLocation = this.npc.getBukkitEntity().getLocation();
    }

    public void sit(Location location) {
        if (this.sitting) {
            return;
        }
        this.eh.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        dB.echoDebug("...NPC moved to chair");
        this.eh.mount((Entity)this.eh);
        this.sitting = true;
        this.chairLocation = location;
    }

    public void stand() {
        if (!this.sitting) {
            return;
        }
        this.eh.mount(null);
        this.chairLocation = null;
        this.sitting = false;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public Location getChair() {
        return this.chairLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.chairLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.chairLocation)) {
            event.setCancelled(true);
        }
    }

    public SittingTrait() {
        super("sitting");
    }
}

