/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.LeatherColorer;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    dNPC npc = null;
    Player player = null;

    public ItemScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public Item getItemFrom(Player player, dNPC npc) {
        Item stack = null;
        try {
            if (this.contains("MATERIAL")) {
                String material = TagManager.tag((OfflinePlayer)player, npc, this.getString("MATERIAL"));
                stack = Item.valueOf(material);
            }
            if (stack == null) {
                return null;
            }
            ItemMeta meta = stack.getItemMeta();
            if (this.contains("DISPLAY NAME")) {
                String displayName = TagManager.tag((OfflinePlayer)player, npc, this.getString("DISPLAY NAME"));
                meta.setDisplayName(displayName);
            }
            if (this.contains("LORE")) {
                ArrayList<String> taggedLore = new ArrayList<String>();
                for (String l : this.getStringList("LORE")) {
                    l = TagManager.tag((OfflinePlayer)player, npc, l);
                    taggedLore.add(l);
                }
                meta.setLore(taggedLore);
            }
            stack.setItemMeta(meta);
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    try {
                        int level = 1;
                        if (enchantment.split(":").length > 1) {
                            level = Integer.valueOf(enchantment.split(":")[1]);
                            enchantment = TagManager.tag((OfflinePlayer)player, npc, enchantment.split(":")[0]);
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.addEnchantment(ench, level);
                    }
                    catch (Exception e) {}
                }
            }
            if (this.contains("COLOR")) {
                LeatherColorer.colorArmor(stack, this.getString("COLOR"));
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = ScriptRegistry.getScriptContainerAs(this.getString("BOOK"), BookScriptContainer.class);
                stack = book.writeBookTo(stack, player, npc);
            }
            stack.setId(this.getName());
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this item script!");
            if (!dB.showStackTraces) {
                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
            } else {
                e.printStackTrace();
            }
            stack = null;
        }
        return stack;
    }

    public void setNPC(dNPC npc) {
        this.npc = npc;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

