/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.dScriptArgument;

public class Script
implements dScriptArgument {
    public static final Pattern matchesScriptPtrn = Pattern.compile("(?:.+:|)(.+)", 2);
    private ScriptContainer container;
    private String prefix = "Script";
    private String name = null;
    private boolean valid = false;

    public static Script valueOf(String string) {
        Script script;
        Matcher m = matchesScriptPtrn.matcher(string);
        if (m.matches() && (script = new Script(m.group(1))).isValid()) {
            return script;
        }
        return null;
    }

    public Script(String scriptName) {
        if (DenizenAPI.getCurrentInstance() == null) {
            return;
        }
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<A>" + this.name + "<Y>(" + this.getType() + ")<G>'  ";
    }

    public String dScriptArg() {
        return this.prefix + ":" + this.name;
    }

    public String dScriptArgValue() {
        return this.name;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

