/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldScriptHelper
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>();
    private Map<String, Integer> current_time = new HashMap<String, Integer>();

    public WorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public boolean doEvent(String eventName, dNPC npc, Player player, Map<String, String> context) {
        boolean cancelled = false;
        for (WorldScriptContainer script : world_scripts.values()) {
            if (script == null || !script.contains("EVENTS.ON " + eventName.toUpperCase())) continue;
            dB.report("Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
            List<ScriptEntry> entries = script.getEntries(player, npc, "events.on " + eventName);
            if (entries.isEmpty()) continue;
            dB.echoDebug(dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
            if (context != null) {
                for (Map.Entry<String, String> entry : context.entrySet()) {
                    ScriptBuilder.addObjectToEntries(entries, entry.getKey(), entry.getValue());
                }
            }
            long id = DetermineCommand.getNewId();
            ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
            ScriptQueue._getInstantQueue(ScriptQueue._getNextId()).addEntries(entries).start();
            if (!DetermineCommand.outcomes.containsKey(id) || !DetermineCommand.outcomes.get(id).equalsIgnoreCase("CANCELLED")) continue;
            dB.echoDebug("Cancel it!!!!!!!!!!!!!!!!!!!!!!!!!!");
            cancelled = true;
        }
        return cancelled;
    }

    @EventHandler
    public void commandEvent(PlayerCommandPreprocessEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("args", event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : "");
        if (this.doEvent(event.getMessage().split(" ")[0].replace("/", "") + " command", null, event.getPlayer(), context)) {
            event.setCancelled(true);
            dB.log("OKAY!!!!!!!!!!!!!");
        }
    }

    @EventHandler
    public void loginEvent(PlayerLoginEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ip", event.getHostname());
        this.doEvent("player login", null, event.getPlayer(), context);
    }

    @EventHandler
    public void loginEvent(PlayerQuitEvent event) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ip", event.getQuitMessage());
        this.doEvent("player quit", null, event.getPlayer(), context);
    }

    @EventHandler
    public void walkOnLocationEvent(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = Location.isSavedLocation(event.getPlayer().getLocation());
        if (name != null) {
            this.doEvent("walked over " + name, null, event.getPlayer(), null);
        }
    }

    public void serverStartEvent() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                WorldScriptHelper.this.timeEvent();
            }
        }, 250L, 250L);
        this.doEvent("server start", null, null, null);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey(world.getName()) && this.current_time.get(world.getName()) == hour) continue;
            this.doEvent(hour + ":00 in " + world.getName(), null, null, null);
            this.current_time.put(world.getName(), hour);
        }
    }
}

