/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import net.aufdemrand.denizen.utilities.DenizenAPI;

public class Settings {
    public static boolean ShowDebug() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Show", true);
    }

    public static String ScriptQueueSpeed() {
        String delay = DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.Queue Speed", "0.5s");
        try {
            if (Double.valueOf(delay) < 1.0) {
                delay = "1t";
            }
        }
        catch (Exception e) {
            delay = "0.5s";
        }
        return delay;
    }

    public static boolean LoadScriptsInSubfolders() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts.Load Scripts in Subfolders", true);
    }

    public static boolean HealthTraitEnabledByDefault() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Enabled", false);
    }

    public static boolean HealthTraitRespawnEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Respawn.Enabled", true);
    }

    public static String HealthTraitRespawnDelay() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Traits.Health.Respawn.Delay", "10s");
    }

    public static boolean TriggerEnabled(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers." + triggerName + ".Enabled", true);
    }

    public static String TriggerDefaultCooldown(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + triggerName + ".Cooldown", "5s");
    }

    public static double TriggerDefaultRange(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers." + triggerName + ".Range", -1.0);
    }

    public static boolean ClickTriggerAllowsLeftClick() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Click.Allows Left Click", false);
    }

    public static String EngageTimeoutInSeconds() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Engage.Timeout", "150s");
    }

    public static String ChatToNpcFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC", "You -> <npc.name.nickname>: <text>");
    }

    public static String ChatToNpcOverheardFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to Bystanders", "<player.name> -> <npc.name.nickname>: <text>");
    }

    public static double ChatToNpcOverhearingRange() {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers.Chat.Overhearing Range", 4.0);
    }

    public static boolean ChatMustSeeNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must Be Able to See NPC", true);
    }

    public static boolean ChatMustLookAtNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must Be Looking in Direction of NPC", true);
    }

    public static boolean ChatGloballyIfFailedChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If Triggers Failed", false);
    }

    public static boolean ChatGloballyIfNoChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If Triggers Missing", true);
    }

    public static boolean ChatGloballyIfUninteractable() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If NPC Uninteractable", true);
    }
}

