/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ExperienceCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int amount = 0;
        Type type = Type.SET;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesInteger(arg)) {
                amount = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("SET, GIVE, TAKE", arg)) {
                type = Type.valueOf(arg.toUpperCase());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("quantity", amount).addObject("type", (Object)type);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Integer quantity = (Integer)scriptEntry.getObject("quantity");
        dB.report(this.name, aH.debugObj("Type", type.toString()) + aH.debugObj("Quantity", quantity.toString()) + aH.debugObj("Player", scriptEntry.getPlayer().getName()));
        switch (type) {
            case SET: {
                scriptEntry.getPlayer().setTotalExperience(0);
                break;
            }
            case GIVE: {
                scriptEntry.getPlayer().setTotalExperience(scriptEntry.getPlayer().getTotalExperience() + quantity);
                break;
            }
            case TAKE: {
                scriptEntry.getPlayer().setTotalExperience(scriptEntry.getPlayer().getTotalExperience() - quantity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

