/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.Anchors;

public class AnchorCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.ADD;
        Location location = null;
        String id = null;
        Integer range = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, WALKTO, WALKNEAR, ASSUME, REMOVE", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.String)) {
                id = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("RANGE", arg, aH.ArgumentType.Integer)) {
                range = aH.getIntegerFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT);
        }
        scriptEntry.addObject("action", (Object)action).addObject("id", id).addObject("range", range).addObject("location", location);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Location location = (Location)scriptEntry.getObject("location");
        Integer range = (Integer)scriptEntry.getObject("range");
        String id = (String)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj("NPC", scriptEntry.getNPC().toString()) + aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id) + (location != null ? location.debug() : "") + (range != null ? aH.debugObj("Range", range.toString()) : ""));
        dNPC npc = scriptEntry.getNPC();
        switch (action) {
            case ADD: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).addAnchor(id, (org.bukkit.Location)location);
                return;
            }
            case ASSUME: {
                npc.getEntity().teleport(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id).getLocation());
                return;
            }
            case WALKNEAR: {
                npc.getNavigator().setTarget(Utilities.getWalkableLocationNear(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id).getLocation(), range));
                return;
            }
            case WALKTO: {
                npc.getNavigator().setTarget(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id).getLocation());
                return;
            }
            case REMOVE: {
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).removeAnchor(((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id));
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME,
        WALKTO,
        WALKNEAR;

    }
}

