/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnnounceCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        AnnounceType announceType = AnnounceType.ALL;
        FormatScriptContainer format = null;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("TO_OPS", arg)) {
                announceType = AnnounceType.TO_OPS;
                continue;
            }
            if (aH.matchesArg("FORMAT", arg)) {
                String formatStr = aH.getStringFrom(arg);
                format = ScriptRegistry.getScriptContainerAs(formatStr, FormatScriptContainer.class);
                if (format != null) {
                    dB.echoDebug("... format set to: " + formatStr);
                    continue;
                }
                dB.echoError("... could not find format for: " + formatStr);
                continue;
            }
            text = aH.getStringFrom(arg);
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text);
        scriptEntry.addObject("type", (Object)announceType);
        scriptEntry.addObject("format", format);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String message;
        String text = (String)scriptEntry.getObject("text");
        AnnounceType type = (AnnounceType)((Object)scriptEntry.getObject("type"));
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        dB.report(this.getName(), aH.debugObj("Message", text) + (format != null ? aH.debugObj("Format", format.getName()) : "") + aH.debugObj("Type", type.name()));
        String string = message = format != null ? format.getFormattedText(scriptEntry) : text;
        if (type == AnnounceType.ALL) {
            this.denizen.getServer().broadcastMessage(message);
        } else if (type == AnnounceType.TO_OPS) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AnnounceType {
        ALL,
        TO_OPS;

    }
}

