/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;

public class IfCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Comparable> comparables = new ArrayList<Comparable>();
        String outcomeCommand = null;
        ArrayList<String> outcomeArgs = new ArrayList<String>();
        String elseCommand = null;
        ArrayList<String> elseArgs = new ArrayList<String>();
        comparables.add(new Comparable());
        int index = 0;
        for (String arg : scriptEntry.getArguments()) {
            if (outcomeCommand == null) {
                if (arg.startsWith("!")) {
                    ((Comparable)comparables.get((int)index)).logic = Logic.NEGATIVE;
                    arg = arg.substring(1);
                }
                if (aH.matchesArg("OR", arg = arg.replace("==", "EQUALS").replace(">=", "ORMORE").replace("<=", "ORLESS").replace("<", "LESS").replace(">", "MORE").replace("||", "OR").replace("&&", "AND")) || aH.matchesArg("AND", arg)) {
                    comparables.add(new Comparable());
                    ((Comparable)comparables.get((int)(++index))).bridge = Bridge.valueOf(arg.toUpperCase());
                    continue;
                }
                if (aH.matchesArg("EQUALS", arg) || aH.matchesArg("MATCHES", arg) || aH.matchesArg("ISEMPTY", arg) || aH.matchesArg("ORMORE", arg) || aH.matchesArg("MORE", arg) || aH.matchesArg("LESS", arg) || aH.matchesArg("ORLESS", arg) || aH.matchesArg("CONTAINS", arg)) {
                    ((Comparable)comparables.get((int)index)).operator = Operator.valueOf(arg.toUpperCase());
                    continue;
                }
                if (this.denizen.getCommandRegistry().get(arg) != null) {
                    outcomeCommand = arg;
                    continue;
                }
                if (((Comparable)comparables.get((int)index)).comparable == null) {
                    ((Comparable)comparables.get((int)index)).comparable = this.findObjectType(arg);
                    continue;
                }
                ((Comparable)comparables.get((int)index)).comparedto = this.matchObjectType((Comparable)comparables.get(index), arg);
                continue;
            }
            if (elseCommand == null) {
                if (aH.matchesArg("ELSE", arg)) {
                    elseCommand = "";
                    continue;
                }
                outcomeArgs.add(arg);
                continue;
            }
            if (elseCommand.equals("")) {
                elseCommand = arg;
                continue;
            }
            elseArgs.add(arg);
        }
        scriptEntry.addObject("comparables", comparables);
        scriptEntry.addObject("outcome-command", outcomeCommand);
        scriptEntry.addObject("outcome-command-args", outcomeArgs.toArray());
        scriptEntry.addObject("else-command", elseCommand);
        scriptEntry.addObject("else-command-args", elseArgs.toArray());
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List comparables = (List)scriptEntry.getObject("comparables");
        int counter = 1;
        for (Comparable com : comparables) {
            block64: {
                block65: {
                    block63: {
                        com.outcome = false;
                        if (!(com.comparable instanceof String)) break block63;
                        String comparable = (String)com.comparable;
                        if (com.comparedto instanceof String || com.operator == Operator.ISEMPTY) {
                            switch (com.operator) {
                                case ISEMPTY: {
                                    if (!comparable.equalsIgnoreCase("EMPTY")) break;
                                    com.outcome = true;
                                    break;
                                }
                                case EQUALS: {
                                    if (!comparable.equalsIgnoreCase((String)com.comparedto)) break;
                                    com.outcome = true;
                                    break;
                                }
                                case CONTAINS: {
                                    if (!comparable.toUpperCase().contains(((String)com.comparedto).toUpperCase())) break;
                                    com.outcome = true;
                                    break;
                                }
                                case MATCHES: {
                                    if (((String)com.comparedto).equalsIgnoreCase("location")) {
                                        if (!aH.matchesLocation("location:" + comparable)) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("pose")) {
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("double")) {
                                        if (!aH.matchesDouble(comparable)) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("integer")) {
                                        if (!aH.matchesInteger(comparable)) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("even integer")) {
                                        if (!aH.matchesInteger(comparable) || aH.getIntegerFrom(comparable) % 2 != 0) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("odd integer")) {
                                        if (!aH.matchesInteger(comparable) || aH.getIntegerFrom(comparable) % 2 != 1) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("duration")) {
                                        if (!aH.matchesDuration("duration:" + comparable)) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("boolean")) {
                                        if (!comparable.equalsIgnoreCase("true") && !comparable.equalsIgnoreCase("false")) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("entitytype")) {
                                        if (!aH.matchesEntityType("entity:" + comparable)) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("livingentity")) {
                                        if (aH.getLivingEntityFrom(comparable) == null) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("npc")) {
                                        if (CitizensAPI.getNPCRegistry().getNPC((Entity)aH.getLivingEntityFrom(comparable)) == null) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("player")) {
                                        if (aH.getPlayerFrom(comparable) == null) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (((String)com.comparedto).equalsIgnoreCase("offlineplayer")) {
                                        if (aH.getOfflinePlayerFrom(comparable) == null) break;
                                        com.outcome = true;
                                        break;
                                    }
                                    if (!((String)com.comparedto).equalsIgnoreCase("item") || !aH.matchesItem("item:" + comparable)) break;
                                    com.outcome = true;
                                    break;
                                }
                                case ORMORE: {
                                    if (((String)com.comparable).length() < ((String)com.comparedto).length()) break;
                                    com.outcome = true;
                                    break;
                                }
                                case ORLESS: {
                                    if (((String)com.comparable).length() > ((String)com.comparedto).length()) break;
                                    com.outcome = true;
                                    break;
                                }
                                case MORE: {
                                    if (((String)com.comparable).length() <= ((String)com.comparedto).length()) break;
                                    com.outcome = true;
                                    break;
                                }
                                case LESS: {
                                    if (((String)com.comparable).length() >= ((String)com.comparedto).length()) break;
                                    com.outcome = true;
                                }
                            }
                        }
                        break block64;
                    }
                    if (!(com.comparable instanceof List)) break block65;
                    switch (com.operator) {
                        case CONTAINS: {
                            for (String string : (List)com.comparable) {
                                if (com.comparedto instanceof Integer) {
                                    if (aH.getIntegerFrom(string) != (Integer)com.comparedto) continue;
                                    com.outcome = true;
                                    continue;
                                }
                                if (com.comparedto instanceof Double) {
                                    if (aH.getDoubleFrom(string) != (Double)com.comparedto) continue;
                                    com.outcome = true;
                                    continue;
                                }
                                if (com.comparedto instanceof Boolean) {
                                    if (Boolean.valueOf(string).booleanValue() != ((Boolean)com.comparedto).booleanValue()) continue;
                                    com.outcome = true;
                                    continue;
                                }
                                if (!(com.comparedto instanceof String) || !string.equalsIgnoreCase((String)com.comparedto)) continue;
                                com.outcome = true;
                            }
                            break block64;
                        }
                        case ORMORE: {
                            if (((List)com.comparable).size() < Integer.parseInt(String.valueOf(com.comparedto))) break;
                            com.outcome = true;
                            break;
                        }
                        case ORLESS: {
                            if (((List)com.comparable).size() > Integer.parseInt(String.valueOf(com.comparedto))) break;
                            com.outcome = true;
                            break;
                        }
                        case MORE: {
                            if (((List)com.comparable).size() <= Integer.parseInt(String.valueOf(com.comparedto))) break;
                            com.outcome = true;
                            break;
                        }
                        case LESS: {
                            if (((List)com.comparable).size() >= Integer.parseInt(String.valueOf(com.comparedto))) break;
                            com.outcome = true;
                        }
                    }
                    break block64;
                }
                if (com.comparable instanceof Double) {
                    if (com.comparedto instanceof Double) {
                        switch (com.operator) {
                            case EQUALS: {
                                if (((Double)com.comparable).compareTo((Double)com.comparedto) != 0) break;
                                com.outcome = true;
                                break;
                            }
                            case ORMORE: {
                                if (((Double)com.comparable).compareTo((Double)com.comparedto) < 0) break;
                                com.outcome = true;
                                break;
                            }
                            case ORLESS: {
                                if (((Double)com.comparable).compareTo((Double)com.comparedto) > 0) break;
                                com.outcome = true;
                                break;
                            }
                            case MORE: {
                                if (((Double)com.comparable).compareTo((Double)com.comparedto) <= 0) break;
                                com.outcome = true;
                                break;
                            }
                            case LESS: {
                                if (((Double)com.comparable).compareTo((Double)com.comparedto) >= 0) break;
                                com.outcome = true;
                            }
                        }
                    }
                } else if (com.comparable instanceof Integer) {
                    if (com.comparedto instanceof Integer) {
                        switch (com.operator) {
                            case EQUALS: {
                                if (((Integer)com.comparable).compareTo((Integer)com.comparedto) != 0) break;
                                com.outcome = true;
                                break;
                            }
                            case ORMORE: {
                                if (((Integer)com.comparable).compareTo((Integer)com.comparedto) < 0) break;
                                com.outcome = true;
                                break;
                            }
                            case ORLESS: {
                                if (((Integer)com.comparable).compareTo((Integer)com.comparedto) > 0) break;
                                com.outcome = true;
                                break;
                            }
                            case MORE: {
                                if (((Integer)com.comparable).compareTo((Integer)com.comparedto) <= 0) break;
                                com.outcome = true;
                                break;
                            }
                            case LESS: {
                                if (((Integer)com.comparable).compareTo((Integer)com.comparedto) >= 0) break;
                                com.outcome = true;
                            }
                        }
                    }
                } else if (com.comparable instanceof Boolean && com.comparedto instanceof Boolean) {
                    com.outcome = Boolean.valueOf(com.comparable.equals((Boolean)com.comparedto)) != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }
            if (com.logic == Logic.NEGATIVE) {
                com.outcome = com.outcome == false;
            }
            dB.echoDebug(ChatColor.YELLOW + "Comparable " + counter + ": " + ChatColor.WHITE + com.toString());
            ++counter;
        }
        int ormet = 0;
        for (Comparable compareable : comparables) {
            if (compareable.bridge != Bridge.OR || !compareable.outcome.booleanValue()) continue;
            ++ormet;
        }
        int andcount = 0;
        int andmet = 0;
        for (Comparable compareable : comparables) {
            if (compareable.bridge != Bridge.AND) continue;
            if (compareable.outcome.booleanValue()) {
                ++andmet;
            }
            ++andcount;
        }
        if (ormet > 0 && andcount == andmet) {
            this.doCommand(scriptEntry);
        } else {
            this.doElse(scriptEntry);
        }
    }

    private Object findObjectType(String arg) {
        if (aH.matchesInteger(arg)) {
            return aH.getIntegerFrom(arg);
        }
        if (aH.matchesDouble(arg)) {
            return aH.getDoubleFrom(arg);
        }
        if (arg.equalsIgnoreCase("true")) {
            return true;
        }
        if (arg.equalsIgnoreCase("false")) {
            return false;
        }
        if (arg.contains("|")) {
            return aH.getListFrom(arg);
        }
        return arg;
    }

    private Object matchObjectType(Comparable match, String arg) {
        Object comparable;
        if (match.operator == Operator.MATCHES) {
            match.comparable = String.valueOf(match.comparable);
        }
        if ((comparable = match.comparable) instanceof String) {
            return arg;
        }
        if (comparable instanceof Double) {
            if (aH.matchesDouble(arg) || aH.matchesInteger(arg)) {
                return aH.getDoubleFrom(arg);
            }
            dB.echoDebug(ChatColor.YELLOW + "WARNING! " + ChatColor.WHITE + "Cannot compare DOUBLE(" + match.comparable + ") with '" + arg + "'. Outcome for this Comparable will be false.");
            return Double.NaN;
        }
        if (comparable instanceof Integer) {
            if (aH.matchesDouble(arg)) {
                match.comparable = Double.valueOf(String.valueOf(match.comparable));
                return aH.getDoubleFrom(arg);
            }
            if (aH.matchesInteger(arg)) {
                return aH.getIntegerFrom(arg);
            }
            dB.echoDebug(ChatColor.YELLOW + "WARNING! " + ChatColor.WHITE + "Cannot compare INTEGER(" + match.comparable + ") with '" + arg + "'. Outcome for this Comparable will be false.");
            return Double.NaN;
        }
        if (comparable instanceof Boolean) {
            return aH.getBooleanFrom(arg);
        }
        if (comparable instanceof List) {
            return arg;
        }
        return arg;
    }

    private void doCommand(ScriptEntry scriptEntry) {
        String outcomeCommand = ((String)scriptEntry.getObject("outcome-command")).toUpperCase();
        String[] outcomeArgs = (String[])Arrays.copyOf((Object[])scriptEntry.getObject("outcome-command-args"), ((Object[])scriptEntry.getObject("outcome-command-args")).length, String[].class);
        try {
            ScriptEntry entry = new ScriptEntry(outcomeCommand, outcomeArgs, scriptEntry.getScript().getContainer()).setPlayer(scriptEntry.getPlayer()).setNPC(scriptEntry.getNPC()).setInstant(true).addObject("reqId", scriptEntry.getObject("reqId"));
            scriptEntry.getResidingQueue().injectEntry(entry, 0);
        }
        catch (ScriptEntryCreationException e) {
            dB.echoError("There has been a problem running the Command. Check syntax.");
            if (dB.showStackTraces) {
                dB.echoDebug("STACKTRACE follows:");
                e.printStackTrace();
            }
            dB.echoDebug("Use '/denizen debug -s' for the nitty-gritty.");
        }
    }

    private void doElse(ScriptEntry scriptEntry) {
        String elseCommand = null;
        if (scriptEntry.getObject("else-command") != null) {
            elseCommand = ((String)scriptEntry.getObject("else-command")).toUpperCase();
        }
        String[] elseArgs = null;
        if (scriptEntry.getObject("else-command-args") != null) {
            elseArgs = (String[])Arrays.copyOf((Object[])scriptEntry.getObject("else-command-args"), ((Object[])scriptEntry.getObject("else-command-args")).length, String[].class);
        }
        if (elseCommand == null) {
            return;
        }
        try {
            ScriptEntry entry = new ScriptEntry(elseCommand, elseArgs, scriptEntry.getScript().getContainer()).setPlayer(scriptEntry.getPlayer()).setNPC(scriptEntry.getNPC()).setInstant(true).addObject("reqId", scriptEntry.getObject("reqId"));
            scriptEntry.getResidingQueue().injectEntry(entry, 0);
        }
        catch (ScriptEntryCreationException e) {
            dB.echoError("There has been a problem running the ELSE Command. Check syntax.");
            if (dB.showStackTraces) {
                dB.echoDebug("STACKTRACE follows:");
                e.printStackTrace();
            }
            dB.echoDebug("Use '/denizen debug -s' for the nitty-gritty.");
        }
    }

    private class Comparable {
        Logic logic = Logic.REGULAR;
        Bridge bridge = Bridge.OR;
        Object comparable = null;
        Operator operator = Operator.EQUALS;
        Object comparedto = true;
        Boolean outcome = null;

        private Comparable() {
        }

        public String toString() {
            return (this.logic != Logic.REGULAR ? "Logic='" + this.logic.toString() + "', " : "") + "Comparable='" + (this.comparable == null ? "null'" : this.comparable.getClass().getSimpleName() + "(" + ChatColor.AQUA + this.comparable + ChatColor.WHITE + ")'") + ", Operator='" + this.operator.toString() + "', ComparedTo='" + (this.comparedto == null ? "null'" : this.comparedto.getClass().getSimpleName() + "(" + ChatColor.AQUA + this.comparedto + ChatColor.WHITE + ")' ") + ChatColor.YELLOW + "--> OUTCOME='" + this.outcome + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Logic {
        REGULAR,
        NEGATIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bridge {
        OR,
        AND,
        FIRST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        EQUALS,
        MATCHES,
        ORMORE,
        ORLESS,
        MORE,
        LESS,
        CONTAINS,
        ISEMPTY;

    }
}

