/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.LookClose;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class LookCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TargetType targetType = TargetType.NPC;
        Integer duration = null;
        Direction direction = null;
        Location location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getIntegerFrom(arg);
                dB.echoDebug("...look duration set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("PLAYER", arg)) {
                targetType = TargetType.PLAYER;
                dB.echoDebug("... will affect the player!");
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set");
                continue;
            }
            for (Direction thisDirection : Direction.values()) {
                if (!arg.toUpperCase().equals(thisDirection.name())) continue;
                direction = Direction.valueOf(arg);
                dB.echoDebug("...set look direction '%s'.", arg);
            }
        }
        if (targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("target", (Object)targetType).addObject("location", location);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        org.bukkit.Location location = (org.bukkit.Location)scriptEntry.getObject("location");
        Player entity = null;
        if (target.name() == "NPC") {
            entity = scriptEntry.getNPC().getCitizen().getBukkitEntity();
            ((LookClose)scriptEntry.getNPC().getCitizen().getTrait(LookClose.class)).lookClose(false);
        } else {
            entity = scriptEntry.getPlayer();
        }
        if (location != null) {
            Utilities.faceLocation((Entity)entity, location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NORTH,
        SOUTH,
        EAST,
        WEST,
        BACK,
        AT,
        CLOSE,
        AWAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

