/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.EntityType;

public class SitCommand
extends AbstractCommand {
    Location location = null;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                this.location = aH.getLocationFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("location", this.location);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        NPC npc = scriptEntry.getNPC().getCitizen();
        SittingTrait trait = (SittingTrait)npc.getTrait(SittingTrait.class);
        if (npc.getBukkitEntity().getType() != EntityType.PLAYER) {
            dB.echoError("...only Player type NPCs can sit!");
            return;
        }
        if (!npc.hasTrait(SittingTrait.class)) {
            npc.addTrait(SittingTrait.class);
            dB.echoDebug("...added sitting trait");
        }
        if (trait.isSitting()) {
            dB.echoError("...NPC is already sitting");
            return;
        }
        if (location != null) {
            trait.sit(location);
        } else {
            trait.sit();
        }
    }
}

