/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import org.bukkit.entity.Player;

public class ExpUtil {
    public static int getTotalExperience(Player p) {
        return ExpUtil.getTotalExperience(p.getLevel(), p.getExp());
    }

    public static int getTotalExperience(int level, double bar) {
        return ExpUtil.getTotalExpToLevel(level) + (int)((double)ExpUtil.getExpToLevel(level + 1) * bar);
    }

    public static int getTotalExpToLevel(int level) {
        if (level < 16) {
            return 17 * level;
        }
        if (level < 31) {
            return (int)(1.5 * (double)level * (double)level - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * (double)level * (double)level - 151.5 * (double)level + 2220.0);
    }

    public static int getExpToLevel(int level) {
        if (level < 16) {
            return 17;
        }
        if (level < 31) {
            return 3 * level - 31;
        }
        return 7 * level - 155;
    }

    public static void clearExperience(Player player) {
        ExpUtil.setTotalExperience(player, 0);
    }

    public static void setTotalExperience(Player player, int exp) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        if (exp > 0) {
            player.giveExp(exp);
        }
    }

    public static void setLevel(Player player, int level) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        if (level > 0) {
            player.giveExp(ExpUtil.getExpToLevel(level));
        }
    }

    public static void giveExperience(Player player, int exp) {
        int currentExp = ExpUtil.getTotalExperience(player);
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        int newexp = currentExp + exp;
        if (newexp > 0) {
            player.giveExp(newexp);
        }
    }
}

