/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.List;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class Player
implements dScriptArgument {
    private String prefix;
    String player;

    public static Player valueOf(String string) {
        if (string == null) {
            return null;
        }
        String prefix = null;
        if (string.split(":").length > 1) {
            prefix = string.split(":", 2)[0];
            string = string.split(":", 2)[1];
        }
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(string)) continue;
            return new Player(prefix, player);
        }
        dB.echoError("Player '" + string + "' is invalid, or has never logged in to this server.");
        return null;
    }

    public org.bukkit.entity.Player getPlayerEntity() {
        return Bukkit.getPlayer((String)this.player);
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((String)this.player);
    }

    public boolean isOnline() {
        return Bukkit.getPlayer((String)this.player) != null;
    }

    public Player(OfflinePlayer player) {
        this(null, player);
    }

    public Player(String prefix, OfflinePlayer player) {
        this.prefix = prefix == null ? "Player" : prefix;
        this.player = player.getName();
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.player + "<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.player;
    }

    public String dScriptArgValue() {
        return this.player;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_played_before")) {
            return new Element(String.valueOf(this.getOfflinePlayer().hasPlayedBefore())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_op")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isOp())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("first_played")) {
            return new Element(String.valueOf(this.getOfflinePlayer().getFirstPlayed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_played")) {
            return new Element(String.valueOf(this.getOfflinePlayer().getLastPlayed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_banned")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isBanned())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_whitelisted")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isWhitelisted())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name") && !this.isOnline()) {
            return new Element(this.player).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_online")) {
            return new Element(String.valueOf(this.isOnline())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history")) {
            return new List(PlayerTags.playerChatHistory.get(this.player)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.bed_spawn")) {
            return new Location(this.getOfflinePlayer().getBedSpawnLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("money")) {
            if (Depends.economy != null) {
                if (attribute.startsWith("money.currency_singular")) {
                    return new Element(Depends.economy.currencyNameSingular()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("money.currency_plural")) {
                    return new Element(Depends.economy.currencyNamePlural()).getAttribute(attribute.fulfill(2));
                }
                return new Element(String.valueOf(Depends.economy.getBalance(this.player))).getAttribute(attribute.fulfill(1));
            }
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            return null;
        }
        if (!this.isOnline()) {
            return new Element(this.dScriptArgValue()).getAttribute(attribute);
        }
        if (attribute.startsWith("xp.to_next_level")) {
            return new Element(String.valueOf(this.getPlayerEntity().getExpToLevel())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.total")) {
            return new Element(String.valueOf(this.getPlayerEntity().getTotalExperience())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.level")) {
            return new Element(String.valueOf(this.getPlayerEntity().getLevel())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp")) {
            return new Element(String.valueOf(this.getPlayerEntity().getExp() * 100.0f)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_in_hand")) {
            return new Item(this.getPlayerEntity().getItemInHand()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name.display")) {
            return new Element(this.getPlayerEntity().getDisplayName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name.list")) {
            return new Element(this.getPlayerEntity().getPlayerListName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.player).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            return new Location(this.getPlayerEntity().getTargetBlock(null, range).getLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location.standing_on")) {
            return new Location(this.getPlayerEntity().getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location.compass_target")) {
            return new Location(this.getPlayerEntity().getCompassTarget()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            return new Location(this.getPlayerEntity().getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.formatted")) {
            int maxHealth = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            if ((double)((float)this.getPlayerEntity().getHealth() / (float)maxHealth) < 0.1) {
                return new Element("dying").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getPlayerEntity().getHealth() / (float)maxHealth) < 0.4) {
                return new Element("seriously wounded").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getPlayerEntity().getHealth() / (float)maxHealth) < 0.75) {
                return new Element("injured").getAttribute(attribute.fulfill(2));
            }
            if ((float)this.getPlayerEntity().getHealth() / (float)maxHealth < 1.0f) {
                return new Element("scraped").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            int maxHealth = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(String.valueOf((float)this.getPlayerEntity().getHealth() / (float)maxHealth * 100.0f)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new Element(String.valueOf(this.getPlayerEntity().getHealth())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level.formatted")) {
            int maxHunger = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHunger = attribute.getIntContext(2);
            }
            if ((double)((float)this.getPlayerEntity().getFoodLevel() / (float)maxHunger) < 0.1) {
                return new Element("starving").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getPlayerEntity().getFoodLevel() / (float)maxHunger) < 0.4) {
                return new Element("famished").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getPlayerEntity().getFoodLevel() / (float)maxHunger) < 0.75) {
                return new Element("parched").getAttribute(attribute.fulfill(2));
            }
            if ((float)this.getPlayerEntity().getFoodLevel() / (float)maxHunger < 1.0f) {
                return new Element("hungry").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("food_level")) {
            return new Element(String.valueOf(this.getPlayerEntity().getFoodLevel())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("permission")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String permission = attribute.getContext(1);
            if (attribute.startsWith("permission.global")) {
                return new Element(String.valueOf(Depends.permissions.has((World)null, this.player, permission))).getAttribute(attribute.fulfill(2));
            }
            return new Element(String.valueOf(Depends.permissions.has(this.getPlayerEntity(), permission))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("group")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String group = attribute.getContext(1);
            if (attribute.startsWith("group.global")) {
                return new Element(String.valueOf(Depends.permissions.playerInGroup((World)null, this.player, group))).getAttribute(attribute.fulfill(2));
            }
            return new Element(String.valueOf(Depends.permissions.playerInGroup(this.getPlayerEntity(), group))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flying")) {
            return new Element(String.valueOf(this.getPlayerEntity().isFlying())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sneaking")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSneaking())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_blocking")) {
            return new Element(String.valueOf(this.getPlayerEntity().isBlocking())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sleeping")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSleeping())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sprinting")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSprinting())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_inside_vehicle")) {
            return new Element(String.valueOf(this.getPlayerEntity().isInsideVehicle())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode.id")) {
            return new Element(String.valueOf(this.getPlayerEntity().getGameMode().getValue())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode")) {
            return new Element(String.valueOf(this.getPlayerEntity().getGameMode().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_on_cursor")) {
            return new Item(this.getPlayerEntity().getItemOnCursor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return new Player((OfflinePlayer)this.getPlayerEntity().getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage_cause")) {
            return new Element(String.valueOf(this.getPlayerEntity().getLastDamageCause().getCause().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage")) {
            return new Element(String.valueOf(this.getPlayerEntity().getLastDamage())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.getPlayerEntity().getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("allowed_flight")) {
            return new Element(String.valueOf(this.getPlayerEntity().getAllowFlight())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("host_name")) {
            return new Element(String.valueOf(this.getPlayerEntity().getAddress().getHostName())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items")) {
            return new Element(String.valueOf(this.getPlayerEntity().getCanPickupItems())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_id")) {
            return new Element(String.valueOf(this.getPlayerEntity().getEntityId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(String.valueOf(this.getPlayerEntity().getFallDistance())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(String.valueOf(this.getPlayerEntity().getUniqueId().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_asleep")) {
            return new Duration(this.getPlayerEntity().getSleepTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("player_time")) {
            return new Element(String.valueOf(this.getPlayerEntity().getPlayerTime())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("player_time_offset")) {
            return new Element(String.valueOf(this.getPlayerEntity().getPlayerTimeOffset())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            // empty if block
        }
        if (attribute.startsWith("equipment")) {
            // empty if block
        }
        if (attribute.startsWith("world")) {
            // empty if block
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return this.dScriptArgValue();
    }
}

