/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;

public class ParticlesTrait
extends Trait {
    Denizen denizen = DenizenAPI.getCurrentInstance();
    World world;
    EffectType effectType = EffectType.NONE;
    int wait = 10;
    int counter = 0;

    public void run() {
        if (this.world == null) {
            return;
        }
        ++this.counter;
        switch (this.effectType) {
            case NONE: {
                break;
            }
            case FLAME: {
                if (this.counter <= this.wait) break;
                this.playFlameEffect();
                this.counter = 0;
                break;
            }
            case ENDER: {
                if (this.counter > this.wait) {
                    this.playEnderEffect();
                    this.counter = 0;
                }
            }
            case SMOKE: {
                if (this.counter > this.wait) {
                    this.playSmokeEffect();
                    this.counter = 0;
                }
            }
            case POTBREAK: {
                if (this.counter <= this.wait) break;
                this.playPotionBreakEffect();
                this.counter = 0;
                break;
            }
        }
    }

    public void onSpawn() {
        this.world = this.npc.getBukkitEntity().getWorld();
    }

    public void playFlameEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
    }

    public void playEnderEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.ENDER_SIGNAL, 0);
    }

    public void playPotionEffect() {
    }

    public void playPotionBreakEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.POTION_BREAK, 0);
    }

    public void playSmokeEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.SMOKE, 0);
        this.world.playEffect(location, Effect.SMOKE, 1);
        this.world.playEffect(location, Effect.SMOKE, 2);
        this.world.playEffect(location, Effect.SMOKE, 3);
        this.world.playEffect(location, Effect.SMOKE, 4);
        this.world.playEffect(location, Effect.SMOKE, 5);
        this.world.playEffect(location, Effect.SMOKE, 6);
        this.world.playEffect(location, Effect.SMOKE, 7);
        this.world.playEffect(location, Effect.SMOKE, 8);
    }

    public void setEffect(String effectType) {
        this.effectType = EffectType.valueOf(effectType.toUpperCase());
    }

    public void setWait(Integer ticks) {
        this.wait = ticks;
    }

    public ParticlesTrait() {
        super("particles");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EffectType {
        NONE,
        SMOKE,
        FLAME,
        ENDER,
        POTBREAK,
        POTION;

    }
}

