/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadCommand
extends AbstractCommand
implements Listener {
    Map<String, Long> chunkDelays = new HashMap<String, Long>();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Chunk chunk = null;
        Duration length = new Duration(0);
        Action action = Action.ADD;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, REMOVE, REMOVEALL", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesLocation(arg)) {
                chunk = aH.getLocationFrom(arg).getChunk();
                continue;
            }
            if (aH.matchesInteger(arg) || aH.matchesDouble(arg) || aH.matchesDuration(arg)) {
                length = Duration.valueOf(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (chunk == null) {
            throw new InvalidArgumentsException(dB.Messages.DEBUG_SET_LOCATION);
        }
        scriptEntry.addObject("action", (Object)action).addObject("chunk", chunk).addObject("length", length);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Chunk chunk = (Chunk)scriptEntry.getObject("chunk");
        Duration length = (Duration)scriptEntry.getObject("length");
        switch (action) {
            case ADD: {
                if (length.getSeconds() != 0.0) {
                    this.chunkDelays.put(chunk.getX() + ", " + chunk.getZ(), System.currentTimeMillis() + length.getMillis());
                } else {
                    this.chunkDelays.put(chunk.getX() + ", " + chunk.getZ(), 0L);
                }
                dB.echoDebug("...added chunk " + chunk.getX() + ", " + chunk.getZ() + " with a " + length.getSeconds() + "delay");
                if (chunk.isLoaded()) break;
                chunk.load();
                break;
            }
            case REMOVE: {
                if (!this.chunkDelays.containsKey(chunk)) break;
                this.chunkDelays.remove(chunk);
                dB.echoDebug("...allowing unloading of chunk " + chunk.getX() + ", " + chunk.getZ());
                break;
            }
            case REMOVEALL: {
                dB.echoDebug("...allowing unloading of all stored chunks");
                this.chunkDelays.clear();
            }
        }
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Chunk", chunk.toString()) + aH.debugObj("Length", length.toString()));
    }

    @EventHandler
    public void stopUnload(ChunkUnloadEvent e) {
        if (this.chunkDelays.containsKey(e.getChunk().getX() + ", " + e.getChunk().getZ())) {
            if (this.chunkDelays.get(e.getChunk().getX() + ", " + e.getChunk().getZ()) == 0L) {
                e.setCancelled(true);
                return;
            }
            if (System.currentTimeMillis() < this.chunkDelays.get(e.getChunk().getX() + ", " + e.getChunk().getZ())) {
                e.setCancelled(true);
                return;
            }
            this.chunkDelays.remove(e.getChunk().getX() + ", " + e.getChunk().getZ());
        }
    }

    @EventHandler
    public void stopDespawn(NPCDespawnEvent e) {
        Chunk chnk = e.getNPC().getBukkitEntity().getLocation().getChunk();
        if (this.chunkDelays.containsKey(chnk.getX() + ", " + chnk.getZ())) {
            if (this.chunkDelays.get(chnk.getX() + ", " + chnk.getZ()) == 0L) {
                e.setCancelled(true);
                return;
            }
            if (System.currentTimeMillis() < this.chunkDelays.get(chnk.getX() + ", " + chnk.getZ())) {
                e.setCancelled(true);
                return;
            }
            this.chunkDelays.remove(chnk.getX() + ", " + chnk.getZ());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        REMOVEALL;

    }
}

