/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NewCommand
extends AbstractCommand
implements Listener {
    private Map<String, Item> itemStacks = new ConcurrentHashMap<String, Item>();
    private Map<String, LivingEntity> entities = new ConcurrentHashMap<String, LivingEntity>();
    private Map<String, Integer> npcs = new ConcurrentHashMap<String, Integer>();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public ItemStack getItem(String id) {
        if (this.itemStacks.containsKey(id.toUpperCase())) {
            return this.itemStacks.get(id.toUpperCase()).getItemStack();
        }
        return null;
    }

    public LivingEntity getEntity(String id) {
        if (this.entities.containsKey(id.toUpperCase())) {
            return this.entities.get(id.toUpperCase());
        }
        return null;
    }

    public NPC getNPC(String id) {
        if (this.npcs.containsKey(id.toUpperCase()) && CitizensAPI.getNPCRegistry().getById(this.npcs.get(id.toUpperCase()).intValue()) != null) {
            return CitizensAPI.getNPCRegistry().getById(this.npcs.get(id.toUpperCase()).intValue());
        }
        return null;
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ObjectType objectType = null;
        String id = null;
        Item item = null;
        int qty = 1;
        Object entity = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ITEMSTACK, ENTITY, NPC", arg)) {
                objectType = ObjectType.valueOf(arg.toUpperCase());
                dB.echoDebug("...set NEW object type: '%s'", arg.toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.String)) {
                id = aH.getStringFrom(arg);
                dB.echoDebug("...set ID: '%s'", id);
                continue;
            }
            if (aH.matchesItem(arg)) {
                item = aH.getItemFrom(arg);
                dB.echoDebug("...set ITEM: '%s'", aH.getStringFrom(arg));
                continue;
            }
            if (!aH.matchesQuantity(arg)) continue;
            qty = aH.getIntegerFrom(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(qty));
        }
        if (objectType == null) {
            throw new InvalidArgumentsException("Must define an ObjectType. Valid: ITEMSTACK, ENTITY, NPC");
        }
        if (id == null) {
            throw new InvalidArgumentsException("Must define an ID.");
        }
        scriptEntry.addObject("type", (Object)objectType);
        scriptEntry.addObject("id", id);
        if (objectType == ObjectType.ITEMSTACK) {
            if (item == null) {
                throw new InvalidArgumentsException("Must specify a valid ITEM.");
            }
            item.getItemStack().setAmount(qty);
            scriptEntry.addObject("itemstack", item);
        } else if (objectType == ObjectType.ENTITY) {
            if (entity == null) {
                throw new InvalidArgumentsException("Must specify a valid ENTITY.");
            }
            scriptEntry.addObject("entity", entity);
        } else if (objectType == ObjectType.NPC) {
            // empty if block
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if ((ObjectType)((Object)scriptEntry.getObject("type")) == ObjectType.ITEMSTACK) {
            String id = (String)scriptEntry.getObject("id");
            dB.echoApproval("New ItemStack created and saved as 'ITEMSTACK." + id + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ObjectType {
        ITEMSTACK,
        ENTITY,
        NPC;

    }
}

