/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.scoreboard;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.aufdemrand.denizen.utilities.scoreboard.ScoreboardAPI;
import net.minecraft.server.v1_5_R2.Packet;
import net.minecraft.server.v1_5_R2.Packet206SetScoreboardObjective;
import net.minecraft.server.v1_5_R2.Packet207SetScoreboardScore;
import net.minecraft.server.v1_5_R2.Packet208SetScoreboardDisplayObjective;
import net.minecraft.server.v1_5_R2.PlayerConnection;
import org.bukkit.craftbukkit.v1_5_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scoreboard {
    private List<Player> players = new LinkedList<Player>();
    private HashMap<String, Integer> items = new HashMap();
    private Type type = Type.SIDEBAR;
    private String name;
    private String displayName = "\u00a74Not initialized";
    private int priority = 10;

    Scoreboard(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        for (Player p : this.players) {
            this.updatePosition(p);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getScoreboardName() {
        return this.displayName;
    }

    public void setScoreboardName(String displayName) {
        this.displayName = displayName;
        Packet206SetScoreboardObjective pack = new Packet206SetScoreboardObjective();
        pack.a = this.name;
        pack.b = displayName;
        pack.c = 2;
        for (Player p : this.players) {
            if (!this.isUnique(p)) continue;
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)pack);
        }
    }

    public void setItem(String name2, int value) {
        this.items.put(name2, value);
        Packet207SetScoreboardScore pack = new Packet207SetScoreboardScore();
        pack.a = name2;
        pack.c = value;
        pack.d = 0;
        pack.b = this.name;
        for (Player p : this.players) {
            if (!this.isUnique(p)) continue;
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)pack);
        }
    }

    public void removeItem(String name2) {
        if (this.items.remove(name2) != null) {
            Packet207SetScoreboardScore pack = new Packet207SetScoreboardScore();
            pack.a = name2;
            pack.c = 0;
            pack.d = 1;
            pack.b = this.name;
            for (Player p : this.players) {
                if (!this.isUnique(p)) continue;
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)pack);
            }
        }
    }

    public boolean hasPlayerAdded(Player p) {
        return this.players.contains(p);
    }

    public List<Player> getAddedPlayers() {
        return this.players;
    }

    public void showToPlayer(Player p, boolean show) {
        if (show) {
            if (!this.players.contains(p)) {
                this.players.add(p);
                ScoreboardAPI.getInstance().updateForPlayer(p);
            }
        } else if (this.players.remove(p)) {
            Packet206SetScoreboardObjective pack = new Packet206SetScoreboardObjective();
            pack.a = this.name;
            pack.b = "";
            pack.c = 1;
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)pack);
            ScoreboardAPI.getInstance().updateForPlayer(p);
        }
    }

    public void showToPlayer(Player p) {
        this.showToPlayer(p, true);
    }

    public void stopShowingAllPlayers() {
        for (Player p : this.players) {
            this.showToPlayer(p, false);
        }
    }

    private void updatePosition(Player p) {
        if (!this.isUnique(p)) {
            return;
        }
        Packet208SetScoreboardDisplayObjective pack2 = new Packet208SetScoreboardDisplayObjective();
        pack2.a = this.type.ordinal();
        pack2.b = this.name;
        ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)pack2);
    }

    public void checkIfNeedsToBeDisabledForPlayer(Player p) {
        if (!this.players.contains(p)) {
            return;
        }
        PlayerConnection conn = ((CraftPlayer)p).getHandle().playerConnection;
        if (!this.isUnique(p)) {
            Packet206SetScoreboardObjective pack = new Packet206SetScoreboardObjective();
            pack.a = this.name;
            pack.b = this.displayName;
            pack.c = 1;
            conn.sendPacket((Packet)pack);
        }
    }

    public void checkIfNeedsToBeEnabledForPlayer(Player p) {
        if (!this.players.contains(p)) {
            return;
        }
        PlayerConnection conn = ((CraftPlayer)p).getHandle().playerConnection;
        if (this.isUnique(p)) {
            Packet206SetScoreboardObjective pack = new Packet206SetScoreboardObjective();
            pack.a = this.name;
            pack.b = this.displayName;
            pack.c = 0;
            conn.sendPacket((Packet)pack);
            for (String name2 : this.items.keySet()) {
                Integer valObj = this.items.get(name2);
                if (valObj == null) continue;
                int val = valObj;
                Packet207SetScoreboardScore pack2 = new Packet207SetScoreboardScore();
                pack2.a = name2;
                pack2.c = val;
                pack2.d = 0;
                pack2.b = this.name;
                conn.sendPacket((Packet)pack2);
            }
            this.updatePosition(p);
        }
    }

    private boolean isUnique(Player p) {
        int myPos = 0;
        for (int i = 0; i < ScoreboardAPI.getInstance().getScoreboards().size(); ++i) {
            if (ScoreboardAPI.getInstance().getScoreboards().get(i) == this) {
                myPos = i;
                break;
            }
            Scoreboard s = ScoreboardAPI.getInstance().getScoreboards().get(i);
            if (s == this || !s.hasPlayerAdded(p) || s.getType() != this.type || s.getPriority() <= this.priority && (i <= myPos || s.getPriority() != this.priority)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PLAYER_LIST,
        SIDEBAR;

    }
}

