/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.scoreboard.Scoreboard;
import net.aufdemrand.denizen.utilities.scoreboard.ScoreboardAPI;

public class ScoreboardCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        String value = null;
        String id = null;
        Integer priority = null;
        Object show = null;
        Integer num = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("SET", arg, aH.ArgumentType.Custom)) {
                action = Action.SET;
                value = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("REMOVE", arg, aH.ArgumentType.Custom)) {
                action = Action.REMOVE;
                value = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesArg("CREATE, DESTROY", arg)) {
                action = Action.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("PRIORITY", arg, aH.ArgumentType.Integer)) {
                priority = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("SHOW", arg)) {
                action = Action.SHOW;
                continue;
            }
            if (aH.matchesArg("HIDE", arg)) {
                action = Action.HIDE;
                continue;
            }
            if (aH.matchesValueArg("VALUE", arg, aH.ArgumentType.Integer)) {
                num = aH.getIntegerFrom(arg);
                continue;
            }
            id = aH.getStringFrom(arg);
        }
        scriptEntry.addObject("action", (Object)action).addObject("value", value).addObject("num", num).addObject("id", id).addObject("priority", priority).addObject("show", show);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String value = (String)scriptEntry.getObject("value");
        Integer num = (Integer)scriptEntry.getObject("num");
        Integer priority = (Integer)scriptEntry.getObject("priority");
        String id = (String)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id) + aH.debugObj("Exists?", ScoreboardAPI.getInstance().getScoreboard(id) != null ? "Yes" : "No"));
        switch (action) {
            case CREATE: {
                ScoreboardAPI.getInstance().createScoreboard(id, priority);
                ScoreboardAPI.getInstance().getScoreboard(id).setScoreboardName(id);
                ScoreboardAPI.getInstance().getScoreboard(id).setType(Scoreboard.Type.SIDEBAR);
                break;
            }
            case DESTROY: {
                ScoreboardAPI.getInstance().getScoreboard(id).stopShowingAllPlayers();
                break;
            }
            case SET: {
                dB.echoDebug(id);
                dB.echoDebug(value);
                dB.echoDebug(num.toString());
                ScoreboardAPI.getInstance().getScoreboard(id).setItem(value, num);
                break;
            }
            case REMOVE: {
                ScoreboardAPI.getInstance().getScoreboard(id).removeItem(value);
                break;
            }
            case SHOW: {
                ScoreboardAPI.getInstance().getScoreboard(id).showToPlayer(scriptEntry.getPlayer());
                break;
            }
            case HIDE: {
                ScoreboardAPI.getInstance().getScoreboard(id).showToPlayer(scriptEntry.getPlayer(), false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        CREATE,
        DESTROY,
        SET,
        REMOVE,
        SHOW,
        HIDE;

    }
}

