/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizen.npc.activities.AbstractActivity;
import net.aufdemrand.denizen.npc.activities.core.WanderGoal;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WanderActivity
extends AbstractActivity
implements Listener {
    private Map<NPC, WanderGoal> wanderMap = new HashMap<NPC, WanderGoal>();

    public boolean addGoal(dNPC npc, String[] arguments, int priority) {
        dB.echoDebug("Adding WANDER Activity.");
        int delay = 10;
        int radius = 5;
        int depth = 2;
        float speed = npc.getNavigator().getDefaultParameters().speedModifier();
        dLocation specifiedLocation = null;
        ArrayList<Material> materialList = new ArrayList<Material>();
        ArrayList<Integer> materialIdList = new ArrayList<Integer>();
        npc.getNavigator().getDefaultParameters().avoidWater(true);
        for (String arg : arguments) {
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Integer)) {
                delay = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("RADIUS", arg, aH.ArgumentType.Integer)) {
                radius = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DEPTH", arg, aH.ArgumentType.Integer)) {
                depth = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SPEED", arg, aH.ArgumentType.Float)) {
                speed = aH.getFloatFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("FILTER", arg, aH.ArgumentType.Custom)) {
                for (String materialString : arg.split(":")[1].split(",")) {
                    try {
                        if (materialString.matches("//d+")) {
                            materialIdList.add(Integer.valueOf(materialString));
                            continue;
                        }
                        materialList.add(Material.valueOf((String)materialString.toUpperCase().trim()));
                    }
                    catch (Exception e) {
                        dB.echoError("...bad argument '%s'! Check to be sure this is a valid Material.", arg);
                    }
                }
                continue;
            }
            if (aH.matchesLocation(arg)) {
                if (aH.getLocationFrom(arg) == null) continue;
                specifiedLocation = aH.getLocationFrom(arg);
                continue;
            }
            dB.echoError("Could not match argument '%s'.", arg);
        }
        if (this.wanderMap.containsKey(npc)) {
            dB.echoDebug("Already found a WANDER instance for this NPC! Removing existing and adding new.");
            this.removeGoal(npc, true);
        }
        this.wanderMap.put(npc.getCitizen(), new WanderGoal(npc, radius, depth, delay, speed, materialList, materialIdList, specifiedLocation, this));
        npc.getCitizen().getDefaultGoalController().addGoal((Goal)this.wanderMap.get(npc.getCitizen()), priority);
        return true;
    }

    public boolean removeGoal(dNPC npc, boolean verbose) {
        WanderGoal goal = this.wanderMap.remove(npc.getCitizen());
        if (goal != null) {
            npc.getCitizen().getDefaultGoalController().removeGoal((Goal)goal);
            if (verbose) {
                dB.echoDebug("Removed Wander Activities from NPC.");
            }
            return true;
        }
        if (verbose) {
            dB.echoError("NPC does not have this activity...");
        }
        return false;
    }

    public Location getNewLocation(double X, double Y, double Z, World world, int radius, int depth) {
        Location newLocation = new Location(world, X, Y, Z);
        Random intRandom = new Random();
        int randomX = intRandom.nextInt(radius * 2) - radius;
        int randomZ = intRandom.nextInt(radius * 2) - radius;
        int randomY = 0;
        randomY = depth > 1 ? intRandom.nextInt(depth * 2) - depth : 2;
        newLocation.setX(newLocation.getX() + (double)randomX);
        newLocation.setZ(newLocation.getZ() + (double)randomZ);
        newLocation.setY(newLocation.getY() + (double)randomY);
        return newLocation;
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        if (this.wanderMap.containsKey(event.getNPC())) {
            this.wanderMap.get(event.getNPC()).cooldown();
        }
    }

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }
}

