/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.InvisibleTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.potion.PotionEffectType;

public class InvisibleCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesToggle(arg)) {
                scriptEntry.addObject("toggle", (Object)Action.valueOf(aH.getStringFrom(arg).toUpperCase()));
                continue;
            }
            if (aH.matchesArg("NPC, PLAYER", arg)) {
                scriptEntry.addObject("target", (Object)Target.valueOf(aH.getStringFrom(arg).toUpperCase()));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (scriptEntry.getObject("toggle") == null) {
            throw new InvalidArgumentsException("Must specify a toggle action!");
        }
        if (scriptEntry.getObject("target") == null) {
            throw new InvalidArgumentsException("Must specify a target!");
        }
        if (scriptEntry.getObject("target") == Target.NPC && scriptEntry.getNPC() == null || scriptEntry.getObject("target") == Target.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException("NPC not found!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("toggle"));
        Target target = (Target)((Object)scriptEntry.getObject("target"));
        dB.report(this.getName(), aH.debugObj("Toggle", action.name()) + aH.debugObj("Target", target == Target.NPC ? scriptEntry.getNPC().toString() : scriptEntry.getPlayer().getName()));
        switch (target) {
            case NPC: {
                if (scriptEntry.getNPC().getEntity().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    dB.echoDebug("NPC IS INVIS!");
                }
                if (!scriptEntry.getNPC().getCitizen().hasTrait(InvisibleTrait.class)) {
                    scriptEntry.getNPC().getCitizen().addTrait(InvisibleTrait.class);
                }
                InvisibleTrait trait = (InvisibleTrait)scriptEntry.getNPC().getCitizen().getTrait(InvisibleTrait.class);
                switch (action) {
                    case FALSE: {
                        trait.setInvisible(false);
                        break;
                    }
                    case TRUE: {
                        trait.setInvisible(true);
                        break;
                    }
                    case TOGGLE: {
                        trait.toggle();
                    }
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Target {
        PLAYER,
        NPC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

