/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.aH;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;

public class YamlCommand
extends AbstractCommand
implements Listener {
    Map<String, YamlConfiguration> yamls = new HashMap<String, YamlConfiguration>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        String key = null;
        String value = null;
        String filename = null;
        String id = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("LOAD, CREATE", arg, aH.ArgumentType.Custom)) {
                action = Action.valueOf(arg.split(":")[0].toUpperCase());
                filename = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesArg("SAVE", arg)) {
                action = Action.SAVE;
                continue;
            }
            if (aH.matchesValueArg("READ, WRITE", arg, aH.ArgumentType.Custom)) {
                action = Action.valueOf(arg.split(":")[0].toUpperCase());
                key = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("VALUE", arg, aH.ArgumentType.Custom)) {
                value = aH.getStringFrom(arg);
                continue;
            }
            id = aH.getStringFrom(arg);
        }
        if (id == null) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (action == null) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        scriptEntry.addObject("filename", filename).addObject("action", (Object)action).addObject("key", key).addObject("value", value).addObject("id", id);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String filename = (String)scriptEntry.getObject("filename");
        String key = (String)scriptEntry.getObject("key");
        String value = (String)scriptEntry.getObject("value");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        switch (action) {
            case LOAD: {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename));
                if (yamlConfiguration == null) break;
                this.yamls.put(filename.toUpperCase(), yamlConfiguration);
                break;
            }
            case SAVE: {
                if (!this.yamls.containsKey(filename.toUpperCase())) break;
                try {
                    this.yamls.get(filename.toUpperCase()).save(new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case WRITE: {
                if (!this.yamls.containsKey(filename.toUpperCase())) break;
                this.yamls.get(filename.toUpperCase()).set(key, (Object)value);
                break;
            }
            case READ: {
                if (!this.yamls.containsKey(filename.toUpperCase())) break;
                this.yamls.get(filename.toUpperCase()).getString(key);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        LOAD,
        CREATE,
        READ,
        WRITE,
        SAVE;

    }
}

