/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.dList;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class dWorld
implements dScriptArgument {
    private String prefix;
    String world_name;

    public static dWorld valueOf(String string) {
        if (string == null) {
            return null;
        }
        String prefix = null;
        if (string.split(":").length > 1) {
            prefix = string.split(":", 2)[0];
            string = string.split(":", 2)[1];
        }
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            return new dWorld(prefix, world);
        }
        dB.echoError("World '" + string + "' is invalid or does not exist.");
        return null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public dWorld(World world) {
        this(null, world);
    }

    public dWorld(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.world_name + "<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.world_name;
    }

    public String dScriptArgValue() {
        return this.world_name;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("highest_block")) {
            int x = 1;
            int z = 1;
            return new dLocation(this.getWorld().getHighestBlockAt(x, z).getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("difficulty")) {
            return new Element(this.getWorld().getDifficulty().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("players")) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : this.getWorld().getPlayers()) {
                players.add(player.getName());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sea_level")) {
            return new Element(String.valueOf(this.getWorld().getSeaLevel())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("seed")) {
            return new Element(String.valueOf(this.getWorld().getSeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time")) {
            return new Element(String.valueOf(this.getWorld().getTime())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather_duration")) {
            return Duration.valueOf(String.valueOf(this.getWorld().getWeatherDuration()) + "t").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_storm")) {
            return new Element(String.valueOf(this.getWorld().hasStorm())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return this.dScriptArgValue();
    }
}

