/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_5_R2.entity.CraftWolf;
import org.bukkit.entity.Wolf;

public class ParticlesTrait
extends Trait {
    Denizen denizen = DenizenAPI.getCurrentInstance();
    World world;
    @Persist(value="effect type")
    EffectType effectType = EffectType.NONE;
    @Persist(value="particle delay")
    int wait = 10;
    int counter = 0;
    int tempcounter = 0;

    public void run() {
        if (this.world == null) {
            return;
        }
        if (this.effectType == null) {
            this.effectType = EffectType.NONE;
        }
        if (this.tempcounter > 20) {
            dB.log("current effect: " + this.effectType.name());
        }
        ++this.counter;
        switch (this.effectType) {
            case NONE: {
                break;
            }
            case FLAME: {
                if (this.counter <= this.wait) break;
                this.playFlameEffect();
                this.counter = 0;
                break;
            }
            case ENDER: {
                if (this.counter > this.wait) {
                    this.playEnderEffect();
                    this.counter = 0;
                }
            }
            case SMOKE: {
                if (this.counter > this.wait) {
                    this.playSmokeEffect();
                    this.counter = 0;
                }
            }
            case POTBREAK: {
                if (this.counter <= this.wait) break;
                this.playPotionBreakEffect();
                this.counter = 0;
                break;
            }
            case POTION: {
                break;
            }
            case HEART: {
                if (this.counter <= this.wait) break;
                this.playHeartEffect();
                this.counter = 0;
                break;
            }
            case EXPLOSION: {
                if (this.counter <= this.wait) break;
                this.playExplosionEffect();
                this.counter = 0;
            }
        }
    }

    public void onSpawn() {
        this.world = this.npc.getBukkitEntity().getWorld();
    }

    public void playFlameEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
    }

    public void playEnderEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.ENDER_SIGNAL, 0);
    }

    public void playPotionEffect() {
    }

    public void playPotionBreakEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.POTION_BREAK, 0);
    }

    public void playHeartEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        Wolf tempWolf = (Wolf)this.world.spawn(location, Wolf.class);
        ((CraftWolf)tempWolf).getHandle().setInvisible(true);
        tempWolf.playEffect(EntityEffect.WOLF_HEARTS);
        tempWolf.remove();
    }

    public void playSmokeEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.playEffect(location, Effect.SMOKE, 0);
        this.world.playEffect(location, Effect.SMOKE, 1);
        this.world.playEffect(location, Effect.SMOKE, 2);
        this.world.playEffect(location, Effect.SMOKE, 3);
        this.world.playEffect(location, Effect.SMOKE, 4);
        this.world.playEffect(location, Effect.SMOKE, 5);
        this.world.playEffect(location, Effect.SMOKE, 6);
        this.world.playEffect(location, Effect.SMOKE, 7);
        this.world.playEffect(location, Effect.SMOKE, 8);
    }

    public void playExplosionEffect() {
        Location location = this.npc.getBukkitEntity().getLocation();
        this.world.createExplosion(location, 0.0f);
    }

    public void setEffect(String effectType) {
        this.effectType = EffectType.valueOf(effectType.toUpperCase());
    }

    public void setWait(Integer ticks) {
        this.wait = ticks;
    }

    public ParticlesTrait() {
        super("particles");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EffectType {
        NONE,
        SMOKE,
        FLAME,
        ENDER,
        POTBREAK,
        HEART,
        POTION,
        EXPLOSION;

    }
}

