/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;

public class FollowCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("STOP", arg)) {
                scriptEntry.addObject("stop", true);
                continue;
            }
            if (aH.matchesValueArg("LEAD", arg, aH.ArgumentType.Double)) {
                scriptEntry.addObject("lead", aH.getDoubleFrom(arg));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Boolean stop = (Boolean)scriptEntry.getObject("stop");
        Double lead = (Double)scriptEntry.getObject("lead");
        dB.report(this.getName(), aH.debugObj("Player", scriptEntry.getPlayer().getName()) + (stop == null ? aH.debugObj("Action", "FOLLOW") : aH.debugObj("Action", "STOP")) + (lead != null ? aH.debugObj("Lead", lead.toString()) : ""));
        if (lead != null) {
            scriptEntry.getNPC().getNavigator().getLocalParameters().distanceMargin(lead.doubleValue());
        }
        if (stop != null) {
            scriptEntry.getNPC().getNavigator().cancelNavigation();
        } else {
            scriptEntry.getNPC().getNavigator().setTarget((LivingEntity)scriptEntry.getPlayer(), false);
        }
    }
}

