/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.plugin.Plugin;

public class VehicleDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleDamagedScriptEvent instance;
    public dEntity vehicle;
    public dEntity entity;
    private double damage;
    public VehicleDamageEvent event;

    public VehicleDamagedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        List<String> split = CoreUtilities.split(lower, ' ');
        if (split.size() > 5) {
            return false;
        }
        if (split.size() > 3 && split.get(3).equals("by")) {
            return false;
        }
        String tid = CoreUtilities.getXthArg(0, lower);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("damaged") && !tid.equals("entity") || cmd.equals("damages");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String ent;
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String veh = cmd.equals("damaged") ? CoreUtilities.getXthArg(0, lower) : CoreUtilities.getXthArg(2, lower);
        String string = ent = cmd.equals("damages") ? CoreUtilities.getXthArg(0, lower) : "";
        if (!this.tryEntity(this.vehicle, veh)) {
            return false;
        }
        if (!ent.isEmpty() && this.entity != null && !this.tryEntity(this.entity, ent)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.vehicle.getLocation());
    }

    @Override
    public String getName() {
        return "VehicleDamaged";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        VehicleDamageEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.damage = aH.getDoubleFrom(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.entity != null) {
            return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
        }
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle.getDenizenObject();
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleDestroyed(VehicleDamageEvent event) {
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.entity = event.getAttacker() != null ? new dEntity(event.getAttacker()) : null;
        this.damage = event.getDamage();
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setDamage(this.damage);
        event.setCancelled(this.cancelled);
    }
}

