/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.List;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PlaySoundCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities") && arg.matchesArgumentList(dLocation.class)) {
                scriptEntry.addObject("locations", arg.asType(dList.class).filter(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dPlayer.class));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("volume, v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("pitch, p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrimitive(aH.PrimitiveType.String)) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("custom") && arg.matches("custom")) {
                scriptEntry.addObject("custom", Element.TRUE);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException("Missing sound argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("volume", new Element(1));
        scriptEntry.defaultObject("pitch", new Element(1));
        scriptEntry.defaultObject("custom", Element.FALSE);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List locations = (List)scriptEntry.getObject("locations");
        List players = (List)scriptEntry.getObject("entities");
        Element sound = scriptEntry.getElement("sound");
        Element volume = scriptEntry.getElement("volume");
        Element pitch = scriptEntry.getElement("pitch");
        Element custom = scriptEntry.getElement("custom");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (locations != null ? aH.debugObj("locations", locations.toString()) : "") + (players != null ? aH.debugObj("entities", players.toString()) : "") + sound.debug() + volume.debug() + pitch.debug() + custom.debug());
        }
        try {
            if (locations != null) {
                if (custom.asBoolean()) {
                    for (dLocation location : locations) {
                        for (Player player : location.getWorld().getPlayers()) {
                            if (!(player.getLocation().distanceSquared((Location)location) < 10000.0)) continue;
                            player.playSound((Location)location, sound.asString(), volume.asFloat(), pitch.asFloat());
                        }
                    }
                } else {
                    for (dLocation location : locations) {
                        location.getWorld().playSound((Location)location, Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat());
                    }
                }
            } else {
                for (dPlayer player : players) {
                    if (custom.asBoolean()) {
                        player.getPlayerEntity().playSound((Location)player.getLocation(), sound.asString(), volume.asFloat(), pitch.asFloat());
                        continue;
                    }
                    player.getPlayerEntity().playSound((Location)player.getLocation(), Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat());
                }
            }
        }
        catch (Exception e) {
            dB.echoDebug((Debuggable)scriptEntry, "Unable to play sound.");
        }
    }
}

