/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;

public class BukkitQueueProperties
implements Property {
    public static final String[] handledMechs = new String[]{"linked_player", "linked_npc"};
    ScriptQueue queue;

    public static boolean describes(ObjectTag script) {
        return script instanceof QueueTag;
    }

    public static BukkitQueueProperties getFrom(ObjectTag queue) {
        if (!BukkitQueueProperties.describes(queue)) {
            return null;
        }
        return new BukkitQueueProperties((QueueTag)queue);
    }

    private BukkitQueueProperties(QueueTag queue) {
        this.queue = queue.getQueue();
    }

    public static void registerTags() {
        PropertyParser.registerTag("npc", (attribute, object) -> {
            NPCTag npc = null;
            if (object.queue.getLastEntryExecuted() != null) {
                npc = ((BukkitScriptEntryData)object.queue.getLastEntryExecuted().entryData).getNPC();
            } else if (object.queue.getEntries().size() > 0) {
                npc = ((BukkitScriptEntryData)object.queue.getEntries().get((int)0).entryData).getNPC();
            } else if (!attribute.hasAlternative()) {
                Debug.echoError(object.queue, "Can't determine a linked NPC.");
            }
            return npc;
        }, new String[0]);
        PropertyParser.registerTag("player", (attribute, object) -> {
            PlayerTag player = null;
            if (object.queue.getLastEntryExecuted() != null) {
                player = ((BukkitScriptEntryData)object.queue.getLastEntryExecuted().entryData).getPlayer();
            } else if (object.queue.getEntries().size() > 0) {
                player = ((BukkitScriptEntryData)object.queue.getEntries().get((int)0).entryData).getPlayer();
            } else {
                Debug.echoError(object.queue, "Can't determine a linked player.");
            }
            return player;
        }, new String[0]);
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitQueueProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        BukkitScriptEntryData data;
        if (mechanism.matches("linked_player") && mechanism.requireObject(PlayerTag.class)) {
            PlayerTag player = mechanism.valueAsType(PlayerTag.class);
            for (ScriptEntry entry : this.queue.getEntries()) {
                data = (BukkitScriptEntryData)entry.entryData;
                data.setPlayer(player);
            }
        }
        if (mechanism.matches("linked_npc") && mechanism.requireObject(NPCTag.class)) {
            NPCTag npc = mechanism.valueAsType(NPCTag.class);
            for (ScriptEntry entry : this.queue.getEntries()) {
                data = (BukkitScriptEntryData)entry.entryData;
                data.setNPC(npc);
            }
        }
    }
}

