/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.plugin.Plugin;

public class EntityShootsBowEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityShootsBowEvent instance;
    public EntityTag entity;
    public ItemTag bow;
    public EntityTag projectile;
    public EntityShootBowEvent event;

    public EntityShootsBowEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("shoots")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String attacker = path.eventArgLowerAt(0);
        String item = path.eventArgLowerAt(2);
        if (!this.tryEntity(this.entity, attacker)) {
            return false;
        }
        if (!item.equals("bow") && !this.tryItem(this.bow, item)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityShootsBow";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (Argument.valueOf(determination).matchesArgumentList(EntityTag.class)) {
            this.cancelled = true;
            List<EntityTag> newProjectiles = ListTag.getListFor(determinationObj, this.getTagContext(path)).filter(EntityTag.class, path.container, true);
            for (EntityTag newProjectile : newProjectiles) {
                newProjectile.spawnAt(this.entity.getEyeLocation().add(this.entity.getEyeLocation().getDirection()));
                if (!newProjectile.isProjectile()) continue;
                newProjectile.setShooter(this.entity);
            }
            Position.mount(Conversion.convertEntities(newProjectiles));
            Entity lastProjectile = newProjectiles.get(newProjectiles.size() - 1).getBukkitEntity();
            lastProjectile.setVelocity(this.event.getEntity().getLocation().getDirection().multiply(this.event.getForce() * 3.0f));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("force")) {
            return new ElementTag(this.event.getForce() * 3.0f);
        }
        if (name.equals("bow")) {
            return this.bow;
        }
        if (name.equals("projectile")) {
            return this.projectile;
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && this.entity.isPlayer()) {
            final Player p = this.entity.getPlayer();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    p.updateInventory();
                }
            }, 1L);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onEntityShootsBow(EntityShootBowEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.bow = new ItemTag(event.getBow());
        Entity projectileEntity = event.getProjectile();
        EntityTag.rememberEntity(projectileEntity);
        this.projectile = new EntityTag(projectileEntity);
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity(projectileEntity);
    }
}

