/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PushableTrait
extends Trait
implements Listener {
    @Persist(value="toggle")
    private boolean pushable = true;
    @Persist(value="returnable")
    private boolean returnable = false;
    @Persist(value="delay")
    private int delay = 2;
    private boolean pushed = false;
    private Location returnLocation = null;
    private long pushedTimer = 0L;

    public PushableTrait() {
        super("pushable");
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isPushable() {
        return this.pushable;
    }

    public boolean isReturnable() {
        return this.returnable;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }

    public void setReturnable(boolean returnable) {
        this.returnable = returnable;
    }

    public boolean toggle() {
        boolean bl = this.pushable = !this.pushable;
        if (!this.pushable) {
            this.returnable = false;
        }
        return this.pushable;
    }

    @EventHandler
    public void NPCPush(NPCPushEvent event) {
        if (event.getNPC() == this.npc && this.pushable) {
            event.setCancelled(false);
            if (System.currentTimeMillis() > this.pushedTimer) {
                Player pusher = null;
                for (Entity le : event.getNPC().getEntity().getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (!(le instanceof Player)) continue;
                    pusher = (Player)le;
                }
                if (pusher != null) {
                    DenizenAPI.getDenizenNPC(this.npc).action("push", PlayerTag.mirrorBukkitPlayer(pusher));
                    this.pushedTimer = System.currentTimeMillis() + (long)(this.delay * 1000);
                }
            }
            if (!this.pushed && this.returnable) {
                this.pushed = true;
                this.returnLocation = this.npc.getEntity().getLocation().clone();
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (PushableTrait.this.npc.isSpawned()) {
                            PushableTrait.this.navigateBack();
                        }
                    }
                }, (long)(this.delay * 20));
            }
        }
    }

    @EventHandler
    public void NPCCompleteDestination(NavigationCompleteEvent event) {
        if (event.getNPC() == this.npc && this.pushed) {
            Entity npcEntity = this.npc.getEntity();
            Location location = npcEntity.getLocation();
            location.setYaw(this.returnLocation.getYaw());
            location.setPitch(this.returnLocation.getPitch());
            NMS.setHeadYaw((Entity)npcEntity, (float)this.returnLocation.getYaw());
            this.pushed = false;
            DenizenAPI.getDenizenNPC(this.npc).action("push return", null);
        }
    }

    protected void navigateBack() {
        if (this.npc.getNavigator().isNavigating()) {
            this.pushed = false;
        } else if (this.pushed) {
            this.pushed = false;
            this.npc.getNavigator().setTarget(this.returnLocation);
            this.pushed = true;
        }
    }
}

