/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class WorldTag
implements ObjectTag,
Adjustable {
    static Map<String, WorldTag> worlds = new HashMap<String, WorldTag>();
    private String prefix;
    String world_name;
    public static ObjectTagProcessor<WorldTag> tagProcessor = new ObjectTagProcessor();

    public static WorldTag mirrorBukkitWorld(World world) {
        if (world == null) {
            return null;
        }
        if (worlds.containsKey(world.getName())) {
            return worlds.get(world.getName());
        }
        return new WorldTag(world);
    }

    @Deprecated
    public static WorldTag valueOf(String string) {
        return WorldTag.valueOf(string, null);
    }

    @Fetchable(value="w")
    public static WorldTag valueOf(String string, TagContext context) {
        return WorldTag.valueOf(string, context == null || context.showErrors());
    }

    public static WorldTag valueOf(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            if (worlds.containsKey(returnable.getName())) {
                return worlds.get(returnable.getName());
            }
            return new WorldTag(returnable);
        }
        if (announce) {
            Debug.echoError("Invalid World! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public String getName() {
        return this.world_name;
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public List<Entity> getEntitiesForTag() {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            List list = this.getWorld().getEntities();
            return list;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public List<LivingEntity> getLivingEntitiesForTag() {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            List list = this.getWorld().getLivingEntities();
            return list;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public WorldTag(World world) {
        this(null, world);
    }

    public WorldTag(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
        if (!worlds.containsKey(world.getName())) {
            worlds.put(world.getName(), this);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "World";
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        WorldTag.registerTag("entities", (attribute, object) -> {
            ListTag entities = new ListTag();
            ListTag typeFilter = attribute.hasContext(1) ? attribute.contextAsType(1, ListTag.class) : null;
            block0: for (Entity entity : object.getEntitiesForTag()) {
                EntityTag current = new EntityTag(entity);
                if (typeFilter != null) {
                    for (String type : typeFilter) {
                        if (!current.comparedTo(type)) continue;
                        entities.addObject(current.getDenizenObject());
                        continue block0;
                    }
                    continue;
                }
                entities.addObject(current.getDenizenObject());
            }
            return entities;
        }, new String[0]);
        WorldTag.registerTag("living_entities", (attribute, object) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            for (Entity entity : object.getLivingEntitiesForTag()) {
                entities.add(new EntityTag(entity));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, new String[0]);
        WorldTag.registerTag("players", (attribute, object) -> {
            ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
            for (Player player : object.getWorld().getPlayers()) {
                if (EntityTag.isNPC((Entity)player)) continue;
                players.add(new PlayerTag(player));
            }
            return new ListTag((Collection<? extends ObjectTag>)players);
        }, new String[0]);
        WorldTag.registerTag("spawned_npcs", (attribute, object) -> {
            ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
            World thisWorld = object.getWorld();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.isSpawned() || !npc.getEntity().getLocation().getWorld().equals(thisWorld)) continue;
                npcs.add(new NPCTag(npc));
            }
            return new ListTag((Collection<? extends ObjectTag>)npcs);
        }, new String[0]);
        WorldTag.registerTag("npcs", (attribute, object) -> {
            ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
            World thisWorld = object.getWorld();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                World world;
                Location location = npc.getStoredLocation();
                if (location == null || (world = location.getWorld()) == null || !world.equals(thisWorld)) continue;
                npcs.add(new NPCTag(npc));
            }
            return new ListTag((Collection<? extends ObjectTag>)npcs);
        }, new String[0]);
        WorldTag.registerTag("can_generate_structures", (attribute, object) -> new ElementTag(object.getWorld().canGenerateStructures()), new String[0]);
        WorldTag.registerTag("loaded_chunks", (attribute, object) -> {
            ListTag chunks = new ListTag();
            for (Chunk ent : object.getWorld().getLoadedChunks()) {
                chunks.addObject(new ChunkTag(ent));
            }
            return chunks;
        }, new String[0]);
        WorldTag.registerTag("random_loaded_chunk", (attribute, object) -> {
            Deprecations.worldRandomLoadedChunkTag.warn(attribute.context);
            int random = CoreUtilities.getRandom().nextInt(object.getWorld().getLoadedChunks().length);
            return new ChunkTag(object.getWorld().getLoadedChunks()[random]);
        }, new String[0]);
        WorldTag.registerTag("sea_level", (attribute, object) -> new ElementTag(object.getWorld().getSeaLevel()), new String[0]);
        WorldTag.registerTag("spawn_location", (attribute, object) -> new LocationTag(object.getWorld().getSpawnLocation()), new String[0]);
        WorldTag.registerTag("world_type", (attribute, object) -> new ElementTag(object.getWorld().getWorldType().getName()), new String[0]);
        WorldTag.registerTag("name", (attribute, object) -> new ElementTag(object.getWorld().getName()), new String[0]);
        WorldTag.registerTag("seed", (attribute, object) -> new ElementTag(object.getWorld().getSeed()), new String[0]);
        WorldTag.registerTag("allows_animals", (attribute, object) -> new ElementTag(object.getWorld().getAllowAnimals()), new String[0]);
        WorldTag.registerTag("allows_monsters", (attribute, object) -> new ElementTag(object.getWorld().getAllowMonsters()), new String[0]);
        WorldTag.registerTag("allows_pvp", (attribute, object) -> new ElementTag(object.getWorld().getPVP()), new String[0]);
        WorldTag.registerTag("auto_save", (attribute, object) -> new ElementTag(object.getWorld().isAutoSave()), new String[0]);
        WorldTag.registerTag("ambient_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getAmbientSpawnLimit()), new String[0]);
        WorldTag.registerTag("animal_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getAnimalSpawnLimit()), new String[0]);
        WorldTag.registerTag("monster_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getMonsterSpawnLimit()), new String[0]);
        WorldTag.registerTag("water_animal_spawn_limit", (attribute, object) -> new ElementTag(object.getWorld().getWaterAnimalSpawnLimit()), new String[0]);
        WorldTag.registerTag("difficulty", (attribute, object) -> new ElementTag(object.getWorld().getDifficulty().name()), new String[0]);
        WorldTag.registerTag("keep_spawn", (attribute, object) -> new ElementTag(object.getWorld().getKeepSpawnInMemory()), new String[0]);
        WorldTag.registerTag("max_height", (attribute, object) -> new ElementTag(object.getWorld().getMaxHeight()), new String[0]);
        WorldTag.registerTag("ticks_per_animal_spawn", (attribute, object) -> new DurationTag(object.getWorld().getTicksPerAnimalSpawns()), new String[0]);
        WorldTag.registerTag("ticks_per_monster_spawn", (attribute, object) -> new DurationTag(object.getWorld().getTicksPerMonsterSpawns()), new String[0]);
        WorldTag.registerTag("time", (attribute, object) -> {
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag(object.getWorld().getTime());
            }
            if (attribute.startsWith("full", 2)) {
                attribute.fulfill(1);
                return new DurationTag(object.getWorld().getFullTime());
            }
            if (attribute.startsWith("period", 2)) {
                attribute.fulfill(1);
                long time = object.getWorld().getTime();
                String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
                return new ElementTag(period);
            }
            return new ElementTag(object.getWorld().getTime());
        }, new String[0]);
        WorldTag.registerTag("moon_phase", (attribute, object) -> new ElementTag((int)(object.getWorld().getFullTime() / 24000L % 8L) + 1), "moonphase");
        WorldTag.registerTag("has_storm", (attribute, object) -> new ElementTag(object.getWorld().hasStorm()), new String[0]);
        WorldTag.registerTag("thunder_duration", (attribute, object) -> new DurationTag((long)object.getWorld().getThunderDuration()), new String[0]);
        WorldTag.registerTag("thundering", (attribute, object) -> new ElementTag(object.getWorld().isThundering()), new String[0]);
        WorldTag.registerTag("weather_duration", (attribute, object) -> new DurationTag((long)object.getWorld().getWeatherDuration()), new String[0]);
        WorldTag.registerTag("environment", (attribute, object) -> new ElementTag(object.getWorld().getEnvironment().name()), new String[0]);
        WorldTag.registerTag("border_size", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getSize()), new String[0]);
        WorldTag.registerTag("border_center", (attribute, object) -> new LocationTag(object.getWorld().getWorldBorder().getCenter()), new String[0]);
        WorldTag.registerTag("border_damage", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getDamageAmount()), new String[0]);
        WorldTag.registerTag("border_damage_buffer", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getDamageBuffer()), new String[0]);
        WorldTag.registerTag("border_warning_distance", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().getWarningDistance()), new String[0]);
        WorldTag.registerTag("border_warning_time", (attribute, object) -> new DurationTag(object.getWorld().getWorldBorder().getWarningTime()), new String[0]);
        WorldTag.registerTag("gamerule", (attribute, object) -> {
            GameRule rule = GameRule.getByName((String)attribute.getContext(1));
            Object result = object.getWorld().getGameRuleValue(rule);
            return new ElementTag(result == null ? "null" : result.toString());
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<WorldTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a world!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String upper;
        Difficulty diff;
        if (mechanism.matches("ambient_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAmbientSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("auto_save") && mechanism.requireBoolean()) {
            this.getWorld().setAutoSave(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("difficulty") && mechanism.requireEnum(true, (Enum<?>[])Difficulty.values()) && (diff = (upper = mechanism.getValue().asString().toUpperCase()).matches("(PEACEFUL|EASY|NORMAL|HARD)") ? Difficulty.valueOf((String)upper) : Difficulty.getByValue((int)mechanism.getValue().asInt())) != null) {
            this.getWorld().setDifficulty(diff);
        }
        if (mechanism.matches("save")) {
            this.getWorld().save();
        }
        if (mechanism.matches("destroy")) {
            if (!Settings.allowDelete()) {
                Debug.echoError("Unable to delete due to config.");
                return;
            }
            File folder = new File(this.getWorld().getName());
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            try {
                CoreUtilities.deleteDirectory(folder);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return;
        }
        if (mechanism.matches("force_unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            return;
        }
        if (mechanism.matches("full_time") && mechanism.requireInteger()) {
            this.getWorld().setFullTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("keep_spawn") && mechanism.requireBoolean()) {
            this.getWorld().setKeepSpawnInMemory(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("monster_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setMonsterSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("allow_pvp") && mechanism.requireBoolean()) {
            this.getWorld().setPVP(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("spawn_location") && mechanism.requireObject(LocationTag.class)) {
            LocationTag loc = mechanism.valueAsType(LocationTag.class);
            this.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
        if (mechanism.matches("storming") && mechanism.requireBoolean()) {
            this.getWorld().setStorm(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("thunder_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setThunderDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("thundering") && mechanism.requireBoolean()) {
            this.getWorld().setThundering(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("ticks_per_animal_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerAnimalSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("ticks_per_monster_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerMonsterSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getWorld().setTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), true);
            return;
        }
        if (mechanism.matches("water_animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setWaterAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("weather_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setWeatherDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

