/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_16.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R2.AxisAlignedBB;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.CombatMath;
import net.minecraft.server.v1_16_R2.DamageSource;
import net.minecraft.server.v1_16_R2.EnchantmentManager;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityInsentient;
import net.minecraft.server.v1_16_R2.EntityLiving;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.EntityPose;
import net.minecraft.server.v1_16_R2.EnumHand;
import net.minecraft.server.v1_16_R2.EnumMonsterType;
import net.minecraft.server.v1_16_R2.EnumMoveType;
import net.minecraft.server.v1_16_R2.GenericAttributes;
import net.minecraft.server.v1_16_R2.ItemStack;
import net.minecraft.server.v1_16_R2.MinecraftKey;
import net.minecraft.server.v1_16_R2.MovingObjectPosition;
import net.minecraft.server.v1_16_R2.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NavigationAbstract;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R2.PathEntity;
import net.minecraft.server.v1_16_R2.PlayerChunkMap;
import net.minecraft.server.v1_16_R2.RayTrace;
import net.minecraft.server.v1_16_R2.RecipeBook;
import net.minecraft.server.v1_16_R2.RecipeBookServer;
import net.minecraft.server.v1_16_R2.Vec3D;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final Field RECIPE_BOOK_DISCOVERED_SET = ReflectionHelper.getFields(RecipeBook.class).get("recipes");
    public static final MethodHandle ENTITY_SETPOSE = ReflectionHelper.getMethodHandle(net.minecraft.server.v1_16_R2.Entity.class, "setPose", EntityPose.class);
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(net.minecraft.server.v1_16_R2.Entity.class, "onGround");
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();

    @Override
    public double getAbsorption(LivingEntity entity) {
        return entity.getAbsorptionAmount();
    }

    @Override
    public void setAbsorption(LivingEntity entity, double value) {
        entity.setAbsorptionAmount(value);
    }

    @Override
    public void setSneaking(Player player, boolean sneak) {
        player.setSneaking(sneak);
        EntityPose pose = sneak ? EntityPose.CROUCHING : EntityPose.STANDING;
        try {
            ENTITY_SETPOSE.invoke(((CraftPlayer)player).getHandle(), pose);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public double getDamageTo(LivingEntity attacker, Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().getMonsterType() : EnumMonsterType.UNDEFINED;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((ItemStack)CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source = attacker instanceof Player ? DamageSource.playerAttack((EntityHuman)((CraftPlayer)attacker).getHandle()) : DamageSource.mobAttack((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            net.minecraft.server.v1_16_R2.Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.isInvulnerable(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.getArmorStrength(), (float)((float)livingTarget.getAttributeInstance(GenericAttributes.ARMOR_TOUGHNESS).getValue()));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.getArmorItems(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    @Override
    public String getRawHoverText(Entity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getDiscoveredRecipes(Player player) {
        try {
            RecipeBookServer book = ((CraftPlayer)player).getHandle().getRecipeBook();
            Set set = (Set)RECIPE_BOOK_DISCOVERED_SET.get(book);
            ArrayList<String> output = new ArrayList<String>();
            for (MinecraftKey key : set) {
                output.add(key.toString());
            }
            return output;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public String getArrowPickupStatus(Entity entity) {
        return ((Arrow)entity).getPickupStatus().name();
    }

    @Override
    public void setArrowPickupStatus(Entity entity, String status) {
        ((Arrow)entity).setPickupStatus(AbstractArrow.PickupStatus.valueOf((String)status));
    }

    @Override
    public double getArrowDamage(Entity arrow) {
        return ((Arrow)arrow).getDamage();
    }

    @Override
    public void setArrowDamage(Entity arrow, double damage) {
        ((Arrow)arrow).setDamage(damage);
    }

    @Override
    public void setCarriedItem(Enderman entity, org.bukkit.inventory.ItemStack item) {
        entity.setCarriedBlock(Bukkit.createBlockData((Material)item.getType()));
    }

    @Override
    public void setRiptide(Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().r(state ? 0 : 1);
    }

    @Override
    public int getBodyArrows(Entity entity) {
        return ((CraftLivingEntity)entity).getHandle().getArrowCount();
    }

    @Override
    public void setBodyArrows(Entity entity, int numArrows) {
        ((CraftLivingEntity)entity).getHandle().setArrowCount(numArrows);
    }

    @Override
    public Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemFromTrident(Entity entity) {
        return CraftItemStack.asBukkitCopy((ItemStack)((CraftTrident)entity).getHandle().trident);
    }

    @Override
    public void setItemForTrident(Entity entity, org.bukkit.inventory.ItemStack item) {
        ((CraftTrident)entity).getHandle().trident = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
    }

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((net.minecraft.server.v1_16_R2.World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.MAIN_HAND, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    @Override
    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.server.v1_16_R2.Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    @Override
    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().a_(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().load(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    @Override
    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    @Override
    public double getSpeed(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
    }

    @Override
    public void setSpeed(Entity entity, double speed) {
        net.minecraft.server.v1_16_R2.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    @Override
    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        net.minecraft.server.v1_16_R2.Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0f);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final LivingEntity entity, Location location, double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        net.minecraft.server.v1_16_R2.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsEntity, true);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 0)) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
            nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.n() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public List<Player> getPlayersThatSee(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().world).getChunkProvider().playerChunkMap;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (EntityPlayer player : entityTracker.trackedPlayers) {
            output.add((Player)player.getBukkitEntity());
        }
        return output;
    }

    @Override
    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            this.ensurePlayerHiding();
            pl.hidePlayer((Plugin)DenizenAPI.getCurrentInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            net.minecraft.server.v1_16_R2.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{other.getId()}));
            }
        }
    }

    @Override
    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)DenizenAPI.getCurrentInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            net.minecraft.server.v1_16_R2.Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = this.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            net.minecraft.server.v1_16_R2.Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    @Override
    public float getBaseYaw(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aD;
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.server.v1_16_R2.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aD = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aC = yaw;
                }
                livingHandle.aE = yaw;
            }
            handle.pitch = pitch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().rayTrace(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.OUTLINE, RayTrace.FluidCollisionOption.NONE, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(world);
        }
    }

    @Override
    public boolean canTrace(World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, endVec);
        if (!(l instanceof MovingObjectPositionBlock) || l.getPos() == null) {
            return null;
        }
        Vector finalVec = new Vector(l.getPos().x, l.getPos().y, l.getPos().z);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (((MovingObjectPositionBlock)l).getDirection()) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    @Override
    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.SELF, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    @Override
    public void teleport(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        Vector size = new Vector(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        return new BoundingBox(position, size);
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    @Override
    public boolean isChestedHorse(Entity horse) {
        return horse instanceof ChestedHorse;
    }

    @Override
    public boolean isCarryingChest(Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    @Override
    public void setCarryingChest(Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }

    @Override
    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ticksLived = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().ticksLived = ticks;
        }
    }
}

