/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.npc.actions.ActionHandler;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class DenizenNPCHelper
implements Listener {
    private Denizen plugin;
    private ActionHandler actionHandler;
    public static Field INVENTORY_TRAIT_VIEW;

    public static DenizenNPCHelper getCurrentInstance() {
        return DenizenAPI.getCurrentInstance().getNPCHelper();
    }

    public DenizenNPCHelper(Denizen denizen) {
        this.plugin = denizen;
        if (Depends.citizens != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            INVENTORY_TRAIT_VIEW = ReflectionHelper.getFields(Inventory.class).get("view");
        }
        this.actionHandler = new ActionHandler(this.plugin);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public static NPCTag getDenizen(NPC npc) {
        return new NPCTag(npc);
    }

    public static NPCTag getDenizen(int id) {
        return new NPCTag(CitizensAPI.getNPCRegistry().getById(id));
    }

    public static org.bukkit.inventory.Inventory getInventory(NPC npc) {
        if (npc == null) {
            return null;
        }
        if (npc.isSpawned() && npc.getEntity() instanceof InventoryHolder) {
            return ((InventoryHolder)npc.getEntity()).getInventory();
        }
        try {
            org.bukkit.inventory.Inventory inv = (org.bukkit.inventory.Inventory)INVENTORY_TRAIT_VIEW.get(DenizenNPCHelper.getDenizen(npc).getInventoryTrait());
            if (inv != null) {
                return inv;
            }
            org.bukkit.inventory.Inventory npcInventory = Bukkit.getServer().createInventory((InventoryHolder)DenizenNPCHelper.getDenizen(npc), InventoryType.PLAYER);
            npcInventory.setContents(Arrays.copyOf(DenizenNPCHelper.getDenizen(npc).getInventoryTrait().getContents(), npcInventory.getSize()));
            return npcInventory;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    @EventHandler
    public void onSpawn(NPCSpawnEvent event) {
        if (event.getNPC() == null) {
            Debug.echoError("Null NPC spawned!");
            return;
        }
        new NPCTag(event.getNPC()).action("spawn", null);
    }

    @EventHandler
    public void despawn(NPCDespawnEvent event) {
        NPCTag npc = DenizenNPCHelper.getDenizen(event.getNPC());
        if (npc != null && npc.isValid()) {
            OldEventManager.doEvents(Arrays.asList("npc despawns"), new BukkitScriptEntryData(null, npc), null);
        }
        if (npc != null && npc.isValid()) {
            npc.action("despawn", null);
        }
    }

    @EventHandler
    public void onRemove(NPCRemoveEvent event) {
        NPC npc = event.getNPC();
        DenizenNPCHelper.getDenizen(npc).action("remove", null);
        FlagManager.clearNPCFlags(npc.getId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        org.bukkit.inventory.Inventory inventory = event.getInventory();
        if (inventory.getHolder() instanceof NPCTag) {
            NPCTag npc = (NPCTag)inventory.getHolder();
            npc.getInventory().setContents(inventory.getContents());
            Equipment equipment = npc.getEquipmentTrait();
            for (int i = 0; i < 5; ++i) {
                equipment.set(i, inventory.getItem(i));
            }
        }
    }
}

