/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.plugin.Plugin;

public class WeatherChangesScriptEvent
extends ScriptEvent
implements Listener {
    public static WeatherChangesScriptEvent instance;
    public dWorld world;
    public Element weather;
    public WeatherChangeEvent event;

    public WeatherChangesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(0, CoreUtilities.toLowerCase(s)).equals("weather");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        if (!cmd.equals("changes") && !cmd.equals(this.weather.identifySimple())) {
            return false;
        }
        String wCheck = CoreUtilities.getXthArg(3, lower);
        return wCheck.length() <= 0 || wCheck.equals(CoreUtilities.toLowerCase(this.world.getName()));
    }

    @Override
    public String getName() {
        return "WeatherChanges";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        WeatherChangeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("weather")) {
            return this.weather;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onWeatherChanges(WeatherChangeEvent event) {
        this.world = new dWorld(event.getWorld());
        this.weather = new Element(event.toWeatherState() ? "rains" : "clears");
        this.event = event;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

