/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class EntityDisabledSlots
implements Property {
    dEntity dentity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntityType() == EntityType.ARMOR_STAND;
    }

    public static EntityDisabledSlots getFrom(dObject entity) {
        if (!EntityDisabledSlots.describes(entity)) {
            return null;
        }
        return new EntityDisabledSlots((dEntity)entity);
    }

    private EntityDisabledSlots(dEntity entity) {
        this.dentity = entity;
    }

    private dList getDisabledSlots() {
        Map<EquipmentSlot, Set<Action>> map = CustomNBT.getDisabledSlots(this.dentity.getBukkitEntity());
        dList list = new dList();
        for (Map.Entry<EquipmentSlot, Set<Action>> entry : map.entrySet()) {
            for (Action action : entry.getValue()) {
                list.add(CoreUtilities.toLowerCase(entry.getKey().name() + "/" + action.name()));
            }
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        dList list = this.getDisabledSlots();
        return list.isEmpty() ? null : list.identify();
    }

    @Override
    public String getPropertyId() {
        return "disabled_slots";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("disabled_slots.raw")) {
            return new Element(CustomNBT.getCustomIntNBT(this.dentity.getBukkitEntity(), "DisabledSlots")).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("disabled_slots")) {
            return this.getDisabledSlots().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("disabled_slots_raw") && mechanism.requireInteger()) {
            CustomNBT.addCustomNBT(this.dentity.getBukkitEntity(), "DisabledSlots", mechanism.getValue().asInt());
        }
        if (mechanism.matches("disabled_slots")) {
            if (!mechanism.hasValue()) {
                CustomNBT.removeCustomNBT(this.dentity.getBukkitEntity(), "DisabledSlots");
                return;
            }
            dList list = mechanism.getValue().asType(dList.class);
            HashMap<EquipmentSlot, Set<Action>> map = new HashMap<EquipmentSlot, Set<Action>>();
            for (String string : list) {
                EquipmentSlot slot;
                String[] split = string.toUpperCase().split("/", 2);
                Action action = null;
                try {
                    slot = EquipmentSlot.valueOf((String)split[0]);
                }
                catch (IllegalArgumentException e) {
                    dB.echoError("Invalid equipment slot specified: " + split[0]);
                    continue;
                }
                if (split.length == 2) {
                    try {
                        action = Action.valueOf(split[1]);
                    }
                    catch (IllegalArgumentException e) {
                        dB.echoError("Invalid action specified: " + split[1]);
                        continue;
                    }
                }
                Set set = map.computeIfAbsent(slot, k -> new HashSet());
                set.add(action == null ? Action.ALL : action);
            }
            CustomNBT.setDisabledSlots(this.dentity.getBukkitEntity(), map);
        }
    }

    public static enum Action {
        ALL(0),
        REMOVE(8),
        PLACE(16);

        private final int id;

        private Action(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

