/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;

public class EntitySpeed
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        dEntity ent = (dEntity)entity;
        if (ent.isLivingEntity()) {
            return true;
        }
        EntityType entityType = ent.getBukkitEntityType();
        return entityType == EntityType.BOAT || entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT;
    }

    public static EntitySpeed getFrom(dObject entity) {
        if (!EntitySpeed.describes(entity)) {
            return null;
        }
        return new EntitySpeed((dEntity)entity);
    }

    private EntitySpeed(dEntity ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.getSpeed().asString();
    }

    @Override
    public String getPropertyId() {
        return "speed";
    }

    public Element getSpeed() {
        if (this.entity.isLivingEntity()) {
            return new Element(NMSHandler.getInstance().getEntityHelper().getSpeed(this.entity.getBukkitEntity()));
        }
        EntityType entityType = this.entity.getBukkitEntityType();
        if (entityType == EntityType.BOAT) {
            return new Element(((Boat)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        if (entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT) {
            return new Element(((Minecart)this.entity.getBukkitEntity()).getMaxSpeed());
        }
        return new Element(0.0);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("speed")) {
            return this.getSpeed().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("speed") && mechanism.requireDouble()) {
            double value = mechanism.getValue().asDouble();
            if (this.entity.isLivingEntity()) {
                NMSHandler.getInstance().getEntityHelper().setSpeed(this.entity.getBukkitEntity(), value);
            } else {
                EntityType entityType = this.entity.getBukkitEntityType();
                if (entityType == EntityType.BOAT) {
                    ((Boat)this.entity.getBukkitEntity()).setMaxSpeed(value);
                } else if (entityType == EntityType.MINECART || entityType == EntityType.MINECART_CHEST || entityType == EntityType.MINECART_COMMAND || entityType == EntityType.MINECART_FURNACE || entityType == EntityType.MINECART_HOPPER || entityType == EntityType.MINECART_MOB_SPAWNER || entityType == EntityType.MINECART_TNT) {
                    ((Minecart)this.entity.getBukkitEntity()).setMaxSpeed(value);
                }
            }
        }
    }
}

