/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.DeterminationTarget;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.QueueWordList;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;

public abstract class ScriptQueue
implements Debuggable,
DefinitionProvider {
    protected static long total_queues = 0L;
    protected static LinkedHashMap<String, ScriptQueue> allQueues = new LinkedHashMap();
    public String id;
    public String debugId;
    public boolean was_cleared = false;
    public boolean procedural = false;
    public Consumer<String> debugOutput = null;
    public final List<ScriptEntry> script_entries = new ArrayList<ScriptEntry>(4);
    private ScriptEntry lastEntryExecuted = null;
    private long delay_time = 0L;
    private final HashMap<String, ObjectTag> definitions = new HashMap();
    public ListTag determinations = null;
    private final HashMap<String, ScriptEntry> held_entries = new HashMap();
    public ScriptTag script;
    public ContextSource contextSource = null;
    public DeterminationTarget determinationTarget = null;
    public ScriptQueue replacementQueue = null;
    public boolean is_started;
    public long startTime = 0L;
    public long startTimeMilli = 0L;
    private Runnable callback = null;
    public boolean is_stopping = false;
    public boolean isStopped = false;
    public boolean waitWhenEmpty = false;

    public static String getStats() {
        StringBuilder stats = new StringBuilder();
        for (ScriptEvent event : ScriptEvent.events) {
            if (event.stats.fires <= 0L) continue;
            stats.append("Event '" + event.getName() + "' ran " + event.stats.fires + " times (" + event.stats.scriptFires + " script fires), totalling " + (float)event.stats.nanoTimes / 1000000.0f + "ms, averaging " + (float)event.stats.nanoTimes / 1000000.0f / (float)event.stats.fires + "ms per event or " + (float)event.stats.nanoTimes / 1000000.0f / (float)event.stats.scriptFires + "ms per script.\n");
        }
        return "Total number of queues created: " + total_queues + ", currently active queues: " + allQueues.size() + ",\n" + stats.toString();
    }

    public static ScriptQueue getExistingQueue(String id) {
        if (!ScriptQueue.queueExists(id)) {
            return null;
        }
        return allQueues.get(id);
    }

    public static String getNextId(String prefix) {
        int size = QueueWordList.FinalWordList.size();
        String id = prefix + "_" + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size));
        return allQueues.containsKey(id) ? ScriptQueue.getNextId(prefix) : id;
    }

    public static Collection<ScriptQueue> getQueues() {
        return allQueues.values();
    }

    public static boolean queueExists(String id) {
        return allQueues.containsKey(id);
    }

    protected ScriptQueue(String id) {
        this.id = id;
        this.generateId(id);
        ++total_queues;
    }

    public ScriptEntry getHeldScriptEntry(String id) {
        return this.held_entries.get(CoreUtilities.toLowerCase(id));
    }

    public ScriptQueue holdScriptEntry(String id, ScriptEntry entry) {
        this.held_entries.put(CoreUtilities.toLowerCase(id), entry);
        return this;
    }

    public ObjectTag getContext(String id) {
        id = CoreUtilities.toLowerCase(id);
        if (this.contextSource == null) {
            return null;
        }
        return this.contextSource.getContext(id);
    }

    public void setContextSource(ContextSource source) {
        this.contextSource = source;
    }

    @Override
    public ObjectTag getDefinitionObject(String definition) {
        if (definition == null) {
            return null;
        }
        return this.definitions.get(CoreUtilities.toLowerCase(definition));
    }

    @Override
    public String getDefinition(String definition) {
        if (definition == null) {
            return null;
        }
        return CoreUtilities.stringifyNullPass(this.definitions.get(CoreUtilities.toLowerCase(definition)));
    }

    @Override
    public boolean hasDefinition(String definition) {
        return this.definitions.containsKey(CoreUtilities.toLowerCase(definition));
    }

    @Override
    public void addDefinition(String definition, ObjectTag value) {
        this.definitions.put(CoreUtilities.toLowerCase(definition), value);
    }

    @Override
    public void addDefinition(String definition, String value) {
        this.definitions.put(CoreUtilities.toLowerCase(definition), new ElementTag(value));
    }

    @Override
    public void removeDefinition(String definition) {
        this.definitions.remove(CoreUtilities.toLowerCase(definition));
    }

    @Override
    public Map<String, ObjectTag> getAllDefinitions() {
        return this.definitions;
    }

    public ScriptEntry getLastEntryExecuted() {
        return this.lastEntryExecuted;
    }

    public void clear() {
        this.was_cleared = true;
        this.script_entries.clear();
    }

    public void delayUntil(long delayTime) {
        this.delay_time = delayTime;
    }

    public void generateId(String prefix) {
        if (prefix.startsWith("FORCE:")) {
            this.debugId = this.id = prefix.substring("FORCE:".length());
            return;
        }
        int size = QueueWordList.FinalWordList.size();
        Random random = CoreUtilities.getRandom();
        String wordOne = QueueWordList.FinalWordList.get(random.nextInt(size));
        String wordTwo = QueueWordList.FinalWordList.get(random.nextInt(size));
        String wordThree = QueueWordList.FinalWordList.get(random.nextInt(size));
        this.id = prefix + "_" + wordOne + wordTwo + wordThree;
        if (ScriptQueue.queueExists(this.id)) {
            this.generateId(prefix);
            return;
        }
        String colorOne = DenizenCore.getImplementation().getRandomColor();
        String colorTwo = DenizenCore.getImplementation().getRandomColor();
        String colorThree = DenizenCore.getImplementation().getRandomColor();
        this.debugId = prefix + "_" + colorOne + wordOne + colorTwo + wordTwo + colorThree + wordThree;
    }

    public TimedQueue forceToTimed(DurationTag delay) {
        Runnable r = this.callback;
        this.callback = null;
        TimedQueue newQueue = new TimedQueue("FORCE:" + this.id, 0L);
        this.replacementQueue = newQueue;
        this.stop();
        newQueue.id = this.id;
        newQueue.debugId = this.debugId;
        newQueue.debugOutput = this.debugOutput;
        for (ScriptEntry scriptEntry : this.getEntries()) {
            scriptEntry.setInstant(true);
            scriptEntry.setSendingQueue(newQueue);
            scriptEntry.updateContext();
        }
        newQueue.addEntries(this.getEntries());
        for (Map.Entry entry : this.getAllDefinitions().entrySet()) {
            newQueue.addDefinition((String)entry.getKey(), (ObjectTag)entry.getValue());
        }
        newQueue.setContextSource(this.contextSource);
        newQueue.determinationTarget = this.determinationTarget;
        for (Map.Entry entry : this.held_entries.entrySet()) {
            newQueue.holdScriptEntry((String)entry.getKey(), (ScriptEntry)entry.getValue());
        }
        newQueue.setLastEntryExecuted(this.getLastEntryExecuted());
        this.clear();
        if (delay != null) {
            newQueue.delayFor(delay);
        }
        newQueue.startTime = this.startTime;
        newQueue.startTimeMilli = this.startTimeMilli;
        newQueue.script = this.script;
        newQueue.callBack(r);
        newQueue.start(false);
        return newQueue;
    }

    public abstract void onStart();

    public String getName() {
        return "UnidentifiedQueueType";
    }

    public void runMeNow() {
        this.onStart();
    }

    public void queueDebug(String message) {
        Debug.echoDebug((Debuggable)this, "<O>" + message.replace("<QUEUE>", this.debugId + "<O>"));
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean doBasicConfig) {
        boolean is_delayed;
        if (this.is_started) {
            return;
        }
        if (this.script_entries.isEmpty()) {
            return;
        }
        allQueues.put(this.id, this);
        this.is_started = true;
        long delay = this.delay_time - DenizenCore.serverTimeMillis;
        boolean bl = is_delayed = delay > 0L;
        if (doBasicConfig) {
            this.script = this.script_entries.get(0).getScript();
            this.startTime = System.nanoTime();
            this.startTimeMilli = System.currentTimeMillis();
        }
        String name = this.getName();
        if (this.queueNeedsToDebug()) {
            if (is_delayed) {
                this.queueDebug("Delaying " + name + " '<QUEUE>' for '" + new DurationTag((double)delay / 1000.0).identify() + "'...");
            } else {
                this.queueDebug("Starting " + name + " '<QUEUE>'" + DenizenCore.getImplementation().queueHeaderInfo(this.script_entries.get(0)) + "...");
            }
        }
        if (is_delayed) {
            OneTimeSchedulable schedulable = new OneTimeSchedulable(new Runnable(){

                @Override
                public void run() {
                    ScriptQueue.this.runMeNow();
                }
            }, (float)delay / 1000.0f);
            DenizenCore.schedule(schedulable);
        } else {
            this.runMeNow();
        }
    }

    public void runNow(List<ScriptEntry> entries) {
        ScriptEntry nextup = this.getQueueSize() > 0 ? this.getEntry(0) : null;
        this.injectEntries(entries, 0);
        while (this.getQueueSize() > 0 && this.getEntry(0) != nextup && !this.was_cleared) {
            this.getEntry(0).setInstant(true);
            this.getEntry(0).setFinished(true);
            DenizenCore.getScriptEngine().revolveOnceForce(this);
        }
    }

    public void callBack(Runnable r) {
        this.callback = r;
    }

    protected abstract void onStop();

    public void stop() {
        if (this.is_stopping) {
            return;
        }
        this.is_stopping = true;
        allQueues.remove(this.id);
        if (this.queueNeedsToDebug()) {
            this.queueDebug("Completing queue '<QUEUE>' in " + (System.nanoTime() - this.startTime) / 1000000L + "ms.");
        }
        if (this.callback != null) {
            this.callback.run();
        }
        this.is_started = false;
        this.onStop();
        this.isStopped = true;
    }

    public void setLastEntryExecuted(ScriptEntry entry) {
        this.lastEntryExecuted = entry;
    }

    public abstract boolean shouldRevolve();

    public void revolve() {
        if (this.script_entries.isEmpty()) {
            if (!this.waitWhenEmpty) {
                this.stop();
            }
            return;
        }
        if (!this.shouldRevolve()) {
            return;
        }
        DenizenCore.getScriptEngine().revolve(this);
        if (this.script_entries.isEmpty() && !this.waitWhenEmpty) {
            this.stop();
        }
    }

    public ScriptEntry getNext() {
        if (!this.script_entries.isEmpty()) {
            return this.script_entries.remove(0);
        }
        return null;
    }

    public ScriptQueue addEntries(List<ScriptEntry> entries) {
        this.script_entries.addAll(entries);
        return this;
    }

    public List<ScriptEntry> getEntries() {
        return this.script_entries;
    }

    public ScriptQueue injectEntries(List<ScriptEntry> entries, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.isEmpty()) {
            position = 0;
        }
        this.script_entries.addAll(position, entries);
        return this;
    }

    public boolean removeEntry(int position) {
        if (this.script_entries.size() < position) {
            return false;
        }
        this.script_entries.remove(position);
        return true;
    }

    public ScriptEntry getEntry(int position) {
        if (this.script_entries.size() < position) {
            return null;
        }
        return this.script_entries.get(position);
    }

    public ScriptQueue injectEntry(ScriptEntry entry, int position) {
        if (position > this.script_entries.size() || position < 0) {
            position = 1;
        }
        if (this.script_entries.isEmpty()) {
            position = 0;
        }
        this.script_entries.add(position, entry);
        return this;
    }

    public int getQueueSize() {
        return this.script_entries.size();
    }

    public boolean queueNeedsToDebug() {
        return DenizenCore.getImplementation().shouldDebug(this);
    }

    @Override
    public boolean shouldDebug() {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.shouldDebug() : this.script_entries.get(0).shouldDebug();
    }

    public String toString() {
        return this.id;
    }
}

