/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.flags;

import com.denizenscript.denizen.utilities.DataPersistenceHelper;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.persistence.PersistentDataHolder;

public class DataPersistenceFlagTracker
extends MapTagBasedFlagTracker {
    public PersistentDataHolder holder;
    public String keyPrefix = "flag_";

    public DataPersistenceFlagTracker(PersistentDataHolder holder) {
        this.holder = holder;
    }

    public DataPersistenceFlagTracker(PersistentDataHolder holder, String keyPrefix) {
        this.holder = holder;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public MapTag getRootMap(String key) {
        return (MapTag)DataPersistenceHelper.getDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key));
    }

    @Override
    public void setRootMap(String key, MapTag map) {
        if (map == null) {
            DataPersistenceHelper.removeDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key));
            return;
        }
        DataPersistenceHelper.setDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key), map);
    }

    @Override
    public Collection<String> listAllFlags() {
        return this.holder.getPersistentDataContainer().getKeys().stream().filter(k -> k.getNamespace().equals("denizen") && k.getKey().startsWith(this.keyPrefix)).map(k -> k.getKey().substring(this.keyPrefix.length())).collect(Collectors.toList());
    }
}

