/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.util.BoundingBox;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;

public class EntityBoundingBox
implements Property {
    private static Set<UUID> modifiedBoxes = new HashSet<UUID>();
    dEntity entity;

    public static boolean describes(dObject object) {
        return object instanceof dEntity;
    }

    public static EntityBoundingBox getFrom(dObject object) {
        if (!EntityBoundingBox.describes(object)) {
            return null;
        }
        return new EntityBoundingBox((dEntity)object);
    }

    public static void remove(UUID uuid) {
        if (modifiedBoxes.contains(uuid)) {
            modifiedBoxes.remove(uuid);
        }
    }

    private EntityBoundingBox(dEntity entity) {
        this.entity = entity;
    }

    private dList getBoundingBox() {
        BoundingBox boundingBox = NMSHandler.getInstance().getEntityHelper().getBoundingBox(this.entity.getBukkitEntity());
        dList list = new dList();
        list.add(new dLocation(boundingBox.getLow().toLocation(this.entity.getWorld())).identify());
        list.add(new dLocation(boundingBox.getHigh().toLocation(this.entity.getWorld())).identify());
        return list;
    }

    @Override
    public String getPropertyString() {
        if (this.entity.isCitizensNPC()) {
            return null;
        }
        if (modifiedBoxes.contains(this.entity.getUUID())) {
            return this.getBoundingBox().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "bounding_box";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("bounding_box")) {
            return this.getBoundingBox().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("bounding_box")) {
            if (this.entity.isCitizensNPC()) {
                return;
            }
            List<dLocation> locations = value.asType(dList.class).filter(dLocation.class);
            if (locations.size() == 2) {
                BoundingBox boundingBox = new BoundingBox(locations.get(0).toVector(), locations.get(1).toVector());
                NMSHandler.getInstance().getEntityHelper().setBoundingBox(this.entity.getBukkitEntity(), boundingBox);
                modifiedBoxes.add(this.entity.getUUID());
            } else {
                dB.echoError("Must specify exactly 2 dLocations in the format '<low>|<high>'!");
            }
        }
    }
}

