/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TimeCommand
extends AbstractCommand {
    public HashMap<UUID, Integer> resetTasks = new HashMap();

    public TimeCommand() {
        this.setName("time");
        this.setSyntax("time ({global}/player) [<time-duration>/reset] (<world>) (reset:<duration>) (freeze)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && !scriptEntry.hasObject("reset") && !arg.matchesPrefix("reset") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("value", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("value") && !scriptEntry.hasObject("reset") && arg.matches("reset")) {
                scriptEntry.addObject("reset", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("freeze") && arg.matches("freeze")) {
                scriptEntry.addObject("freeze", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("reset_after") && arg.matchesPrefix("reset") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("reset_after", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value") && !scriptEntry.hasObject("reset")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        if (!scriptEntry.hasObject("world")) {
            scriptEntry.addObject("world", Utilities.entryDefaultWorld(scriptEntry, false));
        }
        scriptEntry.defaultObject("type", new ElementTag("GLOBAL"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag value = (DurationTag)scriptEntry.getObjectTag("value");
        DurationTag resetAfter = (DurationTag)scriptEntry.getObjectTag("reset_after");
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        ElementTag type_element = scriptEntry.getElement("type");
        ElementTag reset = scriptEntry.getElement("reset");
        ElementTag freeze = scriptEntry.getElement("freeze");
        Type type = Type.valueOf(type_element.asString().toUpperCase());
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), type_element.debug() + (reset != null ? reset.debug() : value.debug()) + (freeze != null ? freeze.debug() : "") + (resetAfter != null ? resetAfter.debug() : "") + world.debug());
        }
        if (type.equals((Object)Type.GLOBAL)) {
            world.getWorld().setTime(value.getTicks());
        } else if (!Utilities.entryHasPlayer(scriptEntry)) {
            Debug.echoError("Must have a valid player link!");
        } else {
            final Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
            if (reset != null && reset.asBoolean()) {
                player.resetPlayerTime();
            } else {
                Integer existingTask = this.resetTasks.get(player.getUniqueId());
                if (existingTask != null) {
                    Bukkit.getScheduler().cancelTask(existingTask.intValue());
                    this.resetTasks.remove(player.getUniqueId());
                }
                player.setPlayerTime(value.getTicks(), freeze == null || !freeze.asBoolean());
                if (resetAfter != null) {
                    int newTask = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            player.resetPlayerTime();
                        }
                    }, resetAfter.getTicks());
                    this.resetTasks.put(player.getUniqueId(), newTask);
                }
            }
        }
    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

