/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.ByteArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.ByteTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.DoubleTag;
import com.denizenscript.denizen.nms.util.jnbt.EndTag;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.LongTag;
import com.denizenscript.denizen.nms.util.jnbt.NBTUtils;
import com.denizenscript.denizen.nms.util.jnbt.ShortTag;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Material;

public class ItemRawNBT
implements Property {
    public static final String[] handledTags = new String[]{"raw_nbt", "all_raw_nbt"};
    public static final String[] handledMechs = new String[]{"raw_nbt"};
    public static StringHolder[] defaultNbtKeys;
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getType() != Material.AIR;
    }

    public static ItemRawNBT getFrom(ObjectTag _item) {
        if (!ItemRawNBT.describes(_item)) {
            return null;
        }
        return new ItemRawNBT((ItemTag)_item);
    }

    private ItemRawNBT(ItemTag _item) {
        this.item = _item;
    }

    public MapTag getNonDefaultNBTMap() {
        MapTag result = this.getFullNBTMap();
        for (StringHolder key : defaultNbtKeys) {
            result.map.remove(key);
        }
        return result;
    }

    public MapTag getFullNBTMap() {
        CompoundTag compoundTag = NMSHandler.getItemHelper().getNbtData(this.item.getItemStack());
        return (MapTag)ItemRawNBT.jnbtTagToObject(compoundTag);
    }

    public static Tag convertObjectToNbt(String object, TagContext context, String path) {
        if (object.startsWith("map@")) {
            MapTag map = MapTag.valueOf(object, context);
            LinkedHashMap<String, Tag> result = new LinkedHashMap<String, Tag>();
            for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                try {
                    result.put(entry.getKey().str, ItemRawNBT.convertObjectToNbt(entry.getValue().toString(), context, path + "." + entry.getKey().str));
                }
                catch (Exception ex) {
                    Debug.echoError("Object NBT interpretation failed for key '" + path + "." + entry.getKey().str + "'.");
                    Debug.echoError(ex);
                    return null;
                }
            }
            return NMSHandler.getInstance().createCompoundTag(result);
        }
        if (object.startsWith("list:")) {
            int nextColonIndex = object.indexOf(58, "list:".length() + 1);
            int typeCode = Integer.parseInt(object.substring("list:".length(), nextColonIndex));
            String listValue = object.substring(nextColonIndex + 1);
            ArrayList<Tag> result = new ArrayList<Tag>();
            ListTag listTag = ListTag.valueOf(listValue, context);
            for (int i = 0; i < listTag.size(); ++i) {
                try {
                    result.add(ItemRawNBT.convertObjectToNbt(listTag.get(i), context, path + "[" + i + "]"));
                    continue;
                }
                catch (Exception ex) {
                    Debug.echoError("Object NBT interpretation failed for list key '" + path + "' at index " + i + ".");
                    Debug.echoError(ex);
                    return null;
                }
            }
            return new JNBTListTag(NBTUtils.getTypeClass(typeCode), result);
        }
        if (object.startsWith("byte_array:")) {
            ListTag numberStrings = ListTag.valueOf(object.substring("byte_array:".length()), context);
            byte[] result = new byte[numberStrings.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Byte.parseByte(numberStrings.get(i));
            }
            return new ByteArrayTag(result);
        }
        if (object.startsWith("int_array:")) {
            ListTag numberStrings = ListTag.valueOf(object.substring("int_array:".length()), context);
            int[] result = new int[numberStrings.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.parseInt(numberStrings.get(i));
            }
            return new IntArrayTag(result);
        }
        if (object.startsWith("byte:")) {
            return new ByteTag(Byte.parseByte(object.substring("byte:".length())));
        }
        if (object.startsWith("short:")) {
            return new ShortTag(Short.parseShort(object.substring("short:".length())));
        }
        if (object.startsWith("int:")) {
            return new IntTag(Integer.parseInt(object.substring("int:".length())));
        }
        if (object.startsWith("long:")) {
            return new LongTag(Long.parseLong(object.substring("long:".length())));
        }
        if (object.startsWith("float:")) {
            return new FloatTag(Float.parseFloat(object.substring("float:".length())));
        }
        if (object.startsWith("double:")) {
            return new DoubleTag(Double.parseDouble(object.substring("double:".length())));
        }
        if (object.startsWith("string:")) {
            return new StringTag(object.substring("string:".length()));
        }
        if (object.equals("end")) {
            return new EndTag();
        }
        if (context == null || context.showErrors()) {
            Debug.echoError("Unknown raw NBT value: " + object);
        }
        return null;
    }

    public static ObjectTag jnbtTagToObject(Tag tag) {
        if (tag instanceof CompoundTag) {
            MapTag result = new MapTag();
            for (Map.Entry entry : ((CompoundTag)tag).getValue().entrySet()) {
                result.putObject((String)entry.getKey(), ItemRawNBT.jnbtTagToObject((Tag)entry.getValue()));
            }
            return result;
        }
        if (tag instanceof JNBTListTag) {
            ListTag result = new ListTag();
            Iterator iterator = ((JNBTListTag)tag).getValue().iterator();
            while (iterator.hasNext()) {
                Tag entry = (Tag)iterator.next();
                result.addObject(ItemRawNBT.jnbtTagToObject(entry));
            }
            return new ElementTag("list:" + NBTUtils.getTypeCode(((JNBTListTag)tag).getType()) + ":" + result.identify());
        }
        if (tag instanceof ByteArrayTag) {
            byte[] data = ((ByteArrayTag)tag).getValue();
            StringBuilder output = new StringBuilder(data.length * 4);
            for (int i = 0; i < data.length; ++i) {
                output.append(data[i]).append("|");
            }
            return new ElementTag("byte_array:" + output.toString());
        }
        if (tag instanceof IntArrayTag) {
            int[] data = ((IntArrayTag)tag).getValue();
            StringBuilder output = new StringBuilder(data.length * 4);
            for (int i = 0; i < data.length; ++i) {
                output.append(data[i]).append("|");
            }
            return new ElementTag("int_array:" + output.toString());
        }
        if (tag instanceof ByteTag) {
            return new ElementTag("byte:" + ((ByteTag)tag).getValue());
        }
        if (tag instanceof ShortTag) {
            return new ElementTag("short:" + ((ShortTag)tag).getValue());
        }
        if (tag instanceof IntTag) {
            return new ElementTag("int:" + ((IntTag)tag).getValue());
        }
        if (tag instanceof LongTag) {
            return new ElementTag("long:" + ((LongTag)tag).getValue());
        }
        if (tag instanceof FloatTag) {
            return new ElementTag("float:" + ((FloatTag)tag).getValue());
        }
        if (tag instanceof DoubleTag) {
            return new ElementTag("double:" + ((DoubleTag)tag).getValue());
        }
        if (tag instanceof StringTag) {
            return new ElementTag("string:" + ((StringTag)tag).getValue());
        }
        if (tag instanceof EndTag) {
            return new ElementTag("end");
        }
        return new ElementTag("unknown:" + tag.getValue());
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("raw_nbt")) {
            return this.getNonDefaultNBTMap().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("all_raw_nbt")) {
            return this.getFullNBTMap().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        MapTag nbt = this.getNonDefaultNBTMap();
        if (!nbt.map.isEmpty()) {
            return nbt.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "raw_nbt";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("raw_nbt") && mechanism.requireObject(MapTag.class)) {
            CompoundTag compoundTag = NMSHandler.getItemHelper().getNbtData(this.item.getItemStack());
            MapTag input = mechanism.valueAsType(MapTag.class);
            LinkedHashMap<String, Tag> result = new LinkedHashMap<String, Tag>((Map<String, Tag>)compoundTag.getValue());
            for (Map.Entry<StringHolder, ObjectTag> entry : input.map.entrySet()) {
                try {
                    Tag tag = ItemRawNBT.convertObjectToNbt(entry.getValue().toString(), mechanism.context, "(item).");
                    if (tag == null) continue;
                    result.put(entry.getKey().str, tag);
                }
                catch (Exception ex) {
                    Debug.echoError("Raw_Nbt input failed for root key '" + entry.getKey().str + "'.");
                    Debug.echoError(ex);
                    return;
                }
            }
            compoundTag = NMSHandler.getInstance().createCompoundTag(result);
            this.item.setItemStack(NMSHandler.getItemHelper().setNbtData(this.item.getItemStack(), compoundTag));
        }
    }

    static {
        String[] defaultNbtKeysRaw = new String[]{"Denizen Item Script", "Denizen NBT", "Denizen", "Damage", "Unbreakable", "CanDestroy", "CustomModelData", "display", "HideFlags", "CanPlaceOn", "BlockEntityTag", "BlockStateTag", "Enchantments", "StoredEnchantments", "RepairCost", "AttributeModifiers", "CustomPotionEffects", "Potion", "CustomPotionColor", "ChargedProjectiles", "resolved", "generation", "author", "title", "pages", "SkullOwner", "Explosion", "Fireworks", "map", "map_scale_direction", "Decorations", "Effects"};
        defaultNbtKeys = new StringHolder[defaultNbtKeysRaw.length];
        for (int i = 0; i < defaultNbtKeysRaw.length; ++i) {
            ItemRawNBT.defaultNbtKeys[i] = new StringHolder(defaultNbtKeysRaw[i]);
        }
    }
}

