/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityKnocksbackEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityKnocksbackEntityScriptEvent instance;
    public EntityTag entity;
    public EntityTag hitBy;
    public ItemTag held;
    public EntityKnockbackByEntityEvent event;

    public EntityKnocksbackEntityScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("knocks") || !path.eventArgLowerAt(2).equals("back")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0)) && this.couldMatchEntity(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String attacker = path.eventArgLowerAt(0);
        String target = path.eventArgLowerAt(3);
        if (!this.tryEntity(this.hitBy, attacker) || !this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!this.runWithCheck(path, this.held)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityKnocksbackEntity";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        if (!EntityKnocksbackEntityScriptEvent.isDefaultDetermination(determinationObj) && LocationTag.matches(determination = determinationObj.toString())) {
            this.event.getAcceleration().copy(LocationTag.valueOf(determination, this.getTagContext(path)).toVector());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.hitBy.isPlayer() ? this.hitBy.getDenizenPlayer() : (this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null), this.hitBy.isCitizensNPC() ? this.hitBy.getDenizenNPC() : (this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null));
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damager")) {
            return this.hitBy.getDenizenObject();
        }
        if (name.equals("acceleration")) {
            return new LocationTag(this.event.getAcceleration());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityKnockbackEntity(EntityKnockbackByEntityEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.hitBy = new EntityTag(event.getHitBy());
        this.held = this.hitBy.getItemInHand();
        this.event = event;
        this.fire((Event)event);
    }
}

