/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizen.utilities.entity.Velocity;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand
implements Listener,
Holdable {
    Map<UUID, EntityTag> arrows = new HashMap<UUID, EntityTag>();

    public ShootCommand() {
        this.setName("shoot");
        this.setSyntax("shoot [<entity>|...] (origin:<entity>/<location>) (destination:<location>) (height:<#.#>) (speed:<#.#>) (script:<name>) (def:<element>|...) (shooter:<entity>) (spread:<#.#>) (lead:<location>) (no_rotate)");
        this.setRequiredArguments(1, 11);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "s")) {
                if (arg.matchesArgumentType(EntityTag.class)) {
                    scriptEntry.addObject("origin_entity", arg.asType(EntityTag.class));
                    continue;
                }
                if (arg.matchesArgumentType(LocationTag.class)) {
                    scriptEntry.addObject("origin_location", arg.asType(LocationTag.class));
                    continue;
                }
                Debug.echoError("Ignoring unrecognized argument: " + arg.getRawValue());
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("lead") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("lead")) {
                scriptEntry.addObject("lead", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesFloat() && arg.matchesPrefix("height", "h")) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat() && arg.matchesPrefix("speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && (arg.matchesArgumentType(ScriptTag.class) && arg.asType(ScriptTag.class).getContainer() instanceof TaskScriptContainer || arg.matchesPrefix("script"))) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("shooter") && arg.matchesArgumentType(EntityTag.class) && arg.matchesPrefix("shooter")) {
                scriptEntry.addObject("shooter", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("gravity") && arg.matchesFloat() && arg.matchesPrefix("gravity", "g")) {
                scriptEntry.addObject("gravity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("spread") && arg.matchesFloat() && arg.matchesPrefix("spread")) {
                scriptEntry.addObject("spread", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("no_rotate") && arg.matches("no_rotate")) {
                scriptEntry.addObject("no_rotate", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("def", "define", "context")) {
                scriptEntry.addObject("definitions", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("origin_location")) {
            scriptEntry.defaultObject("origin_entity", Utilities.entryDefaultEntity(scriptEntry, false));
        }
        scriptEntry.defaultObject("height", new ElementTag(3));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("origin_entity") && !scriptEntry.hasObject("origin_location")) {
            throw new InvalidArgumentsException("Must specify an origin location!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        LocationTag destination;
        boolean no_rotate;
        EntityTag originEntity = (EntityTag)scriptEntry.getObjectTag("origin_entity");
        LocationTag originLocation = scriptEntry.hasObject("origin_location") ? (LocationTag)scriptEntry.getObject("origin_location") : new LocationTag(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()));
        boolean bl = no_rotate = scriptEntry.hasObject("no_rotate") && scriptEntry.getElement("no_rotate").asBoolean();
        LocationTag locationTag = scriptEntry.hasObject("destination") ? (LocationTag)scriptEntry.getObject("destination") : (originEntity != null ? new LocationTag(originEntity.getEyeLocation().clone().add(originEntity.getEyeLocation().clone().getDirection().multiply(30))) : (destination = originLocation != null ? new LocationTag(originLocation.clone().add(originLocation.getDirection().multiply(30))) : null));
        if (destination == null) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), "No destination specified!");
            }
            return;
        }
        final List entities = (List)scriptEntry.getObject("entities");
        final ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        final ListTag definitions = (ListTag)scriptEntry.getObjectTag("definitions");
        EntityTag shooter = (EntityTag)scriptEntry.getObjectTag("shooter");
        ElementTag height = scriptEntry.getElement("height");
        ElementTag gravity = scriptEntry.getElement("gravity");
        ElementTag speed = scriptEntry.getElement("speed");
        ElementTag spread = scriptEntry.getElement("spread");
        LocationTag lead = (LocationTag)scriptEntry.getObjectTag("lead");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("origin", originEntity != null ? originEntity : originLocation) + ArgumentHelper.debugObj("entities", entities.toString()) + destination.debug() + height.debug() + (gravity != null ? gravity.debug() : "") + (speed != null ? speed.debug() : "") + (script != null ? script.debug() : "") + (shooter != null ? shooter.debug() : "") + (spread != null ? spread.debug() : "") + (lead != null ? lead.debug() : "") + (no_rotate ? ArgumentHelper.debugObj("no_rotate", "true") : "") + (definitions != null ? definitions.debug() : ""));
        }
        final ListTag entityList = new ListTag();
        if (!no_rotate) {
            originLocation = new LocationTag(NMSHandler.getEntityHelper().faceLocation(originLocation, (Location)destination));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned() || !no_rotate) {
                entity.spawnAt(originLocation);
            }
            entityList.addObject(entity);
            if (!no_rotate) {
                NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)destination);
            }
            if (!entity.isProjectile() || shooter == null && originEntity == null) continue;
            entity.setShooter(shooter != null ? shooter : originEntity);
            if (script == null) continue;
            this.arrows.put(entity.getUUID(), null);
        }
        scriptEntry.addObject("shot_entities", entityList);
        if (entityList.size() == 1) {
            scriptEntry.addObject("shot_entity", entityList.getObject(0));
        }
        if (spread == null) {
            Position.mount(Conversion.convertEntities(entities));
        }
        final EntityTag lastEntity = (EntityTag)entities.get(entities.size() - 1);
        if (gravity == null) {
            gravity = new ElementTag(lastEntity.getEntityType().getGravity());
        }
        if (speed == null) {
            Vector v1 = lastEntity.getLocation().toVector();
            Vector v2 = destination.toVector();
            Vector v3 = Velocity.calculate(v1, v2, gravity.asDouble(), height.asDouble());
            lastEntity.setVelocity(v3);
        } else if (lead == null) {
            Vector relative = destination.clone().subtract(originLocation).toVector();
            lastEntity.setVelocity(relative.normalize().multiply(speed.asDouble()));
        } else {
            double g = 20.0;
            double v = speed.asDouble();
            Vector relative = destination.clone().subtract(originLocation).toVector();
            double testAng = Velocity.launchAngle(originLocation, destination.toVector(), v, relative.getY(), g);
            double hangTime = Velocity.hangtime(testAng, v, relative.getY(), g);
            Vector to = destination.clone().add(lead.clone().multiply(hangTime)).toVector();
            relative = to.clone().subtract(originLocation.toVector());
            double dist = Math.sqrt(relative.getX() * relative.getX() + relative.getZ() * relative.getZ());
            if (dist == 0.0) {
                dist = 0.1;
            }
            testAng = Velocity.launchAngle(originLocation, to, v, relative.getY(), g);
            relative.setY(Math.tan(testAng) * dist);
            relative = relative.normalize();
            relative = relative.multiply((v += 1.188 * Math.pow(hangTime, 2.0)) / 20.0);
            lastEntity.setVelocity(relative);
        }
        if (spread != null) {
            Vector base = lastEntity.getVelocity().clone();
            float sf = spread.asFloat();
            for (EntityTag entity : entities) {
                Vector newvel = Velocity.spread(base, (double)(CoreUtilities.getRandom().nextDouble() > 0.5 ? 1 : -1) * Math.toRadians(CoreUtilities.getRandom().nextDouble() * (double)sf), (double)(CoreUtilities.getRandom().nextDouble() > 0.5 ? 1 : -1) * Math.toRadians(CoreUtilities.getRandom().nextDouble() * (double)sf));
                entity.setVelocity(newvel);
            }
        }
        final LocationTag start = new LocationTag(lastEntity.getLocation());
        final Vector start_vel = lastEntity.getVelocity();
        BukkitRunnable task = new BukkitRunnable(){
            boolean flying = true;
            LocationTag lastLocation = null;
            Vector lastVelocity = null;

            public void run() {
                if (!lastEntity.isSpawned()) {
                    this.flying = false;
                } else if (this.lastLocation != null && this.lastVelocity != null && (this.lastLocation.getWorld() != lastEntity.getBukkitEntity().getWorld() || this.lastLocation.distanceSquared(lastEntity.getBukkitEntity().getLocation()) < 0.1 && this.lastVelocity.distanceSquared(lastEntity.getBukkitEntity().getVelocity()) < 0.1)) {
                    this.flying = false;
                }
                if (!this.flying) {
                    this.cancel();
                    if (script != null) {
                        if (this.lastLocation == null) {
                            this.lastLocation = start;
                        }
                        if (this.lastVelocity == null) {
                            this.lastVelocity = start_vel;
                        }
                        ListTag hitEntities = new ListTag();
                        for (EntityTag entity : entities) {
                            if (!ShootCommand.this.arrows.containsKey(entity.getUUID())) continue;
                            EntityTag hit = ShootCommand.this.arrows.get(entity.getUUID());
                            ShootCommand.this.arrows.remove(entity.getUUID());
                            if (hit == null) continue;
                            hitEntities.addObject(hit);
                        }
                        Consumer<ScriptQueue> configure = queue -> {
                            queue.addDefinition("location", this.lastLocation);
                            queue.addDefinition("shot_entities", entityList);
                            queue.addDefinition("last_entity", lastEntity);
                            queue.addDefinition("hit_entities", hitEntities);
                        };
                        ScriptUtilities.createAndStartQueue(script.getContainer(), null, scriptEntry.entryData, null, configure, null, null, definitions, scriptEntry);
                    }
                    scriptEntry.setFinished(true);
                } else {
                    this.lastLocation = lastEntity.getLocation();
                    this.lastVelocity = lastEntity.getVelocity();
                }
            }
        };
        if (script != null || !scriptEntry.shouldWaitFor()) {
            task.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 2L);
        }
    }

    @EventHandler
    public void arrowDamage(EntityDamageByEntityEvent event) {
        Entity arrow = event.getDamager();
        if (!(arrow instanceof Projectile)) {
            return;
        }
        if (!this.arrows.containsKey(arrow.getUniqueId())) {
            return;
        }
        this.arrows.remove(arrow.getUniqueId());
        this.arrows.put(arrow.getUniqueId(), new EntityTag(event.getEntity()));
    }
}

